/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.analytics.models;

import android.text.TextUtils;
import com.aniways.Log;
import com.aniways.analytics.utils.ISO8601;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EasyJSONObject
extends JSONObject {
    private static final String TAG = "AniwaysEasyJSONObject";

    public EasyJSONObject() {
    }

    public EasyJSONObject(JSONObject obj) {
        if (obj != null) {
            Iterator keys = obj.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                try {
                    Object val = obj.get(key);
                    this.putObject(key, val);
                }
                catch (JSONException e) {
                    Log.wToGaOnly(true, TAG, "JSON object had an invalid value during merge. ", e);
                }
            }
        }
    }

    public EasyJSONObject(Object ... kvs) {
        if (kvs != null) {
            if (kvs.length % 2 != 0) {
                Log.wToGaOnly(true, TAG, "Segment.io objects must be initialized with an even number of arguments, like so: [Key, Value, Key, Value]", null);
            } else if (kvs.length > 1) {
                for (int i = 0; i < kvs.length; i += 2) {
                    String key = kvs[i].toString();
                    Object val = kvs[i + 1];
                    this.putObject(key, val);
                }
            }
        }
    }

    public void put(String key, Calendar calendar) {
        if (calendar == null) {
            this.remove(key);
        } else {
            Date date = calendar.getTime();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS", Locale.US);
            format.setTimeZone(TimeZone.getTimeZone("UTC"));
            String timestampStr = format.format(date);
            this.putObject(key, timestampStr);
        }
    }

    public JSONObject put(String key, int value) {
        return this.putObject(key, value);
    }

    public JSONObject put(String key, double value) {
        return this.putObject(key, value);
    }

    public JSONObject put(String key, boolean value) {
        return this.putObject(key, value);
    }

    public JSONObject put(String key, long value) {
        return this.putObject(key, value);
    }

    public JSONObject put(String key, float value) {
        return this.putObject(key, Float.valueOf(value));
    }

    public <T> JSONObject put(String key, T[] value) {
        if (value == null) {
            return this.putObject(key, value);
        }
        JSONArray arr = new JSONArray();
        for (T obj : value) {
            arr.put(obj);
        }
        return this.put(key, arr);
    }

    public JSONObject put(String key, String value) {
        return this.putObject(key, value);
    }

    public JSONObject put(String key, JSONObject value) {
        return this.putObject(key, value);
    }

    public JSONObject put(String key, JSONArray value) {
        return this.putObject(key, value);
    }

    public JSONObject put(String key, Object value) {
        return this.putObject(key, value);
    }

    public JSONObject putObject(String key, Object value) {
        try {
            return super.put(key, value);
        }
        catch (JSONException e) {
            Log.eToGaOnly(true, TAG, "Failed to add json key => value" + String.format("[%s => %s] : ", key, value), e);
            return null;
        }
    }

    public Calendar getCalendar(String key) {
        String timestampStr = this.optString(key, null);
        if (timestampStr != null) {
            try {
                return ISO8601.toCalendar(timestampStr);
            }
            catch (ParseException e) {
                Log.wToGaOnly(true, TAG, "Failed to parse timestamp string into ISO 8601 format: " + timestampStr, e);
            }
        }
        return null;
    }

    public <T> List<T> getArray(String key) {
        try {
            JSONArray array = this.getJSONArray(key);
            LinkedList<Object> list = new LinkedList<Object>();
            for (int i = 0; i < array.length(); ++i) {
                Object obj = array.get(i);
                list.add(obj);
            }
            return list;
        }
        catch (JSONException e) {
            return null;
        }
    }

    public JSONObject getObject(String key) {
        try {
            return this.getJSONObject(key);
        }
        catch (JSONException e) {
            return null;
        }
    }

    public String getString(String key) {
        try {
            return super.getString(key);
        }
        catch (JSONException e) {
            return null;
        }
    }

    public String getString(String key, String defaultString) {
        try {
            String str = super.getString(key);
            if (TextUtils.isEmpty((CharSequence)str)) {
                return defaultString;
            }
            return str;
        }
        catch (JSONException e) {
            return defaultString;
        }
    }

    public Boolean getBoolean(String key, Boolean defaultBoolean) {
        try {
            return super.getBoolean(key);
        }
        catch (JSONException e) {
            return defaultBoolean;
        }
    }

    public Integer getInt(String key, Integer defaultInteger) {
        try {
            return super.getInt(key);
        }
        catch (JSONException e) {
            return defaultInteger;
        }
    }

    public Double getDouble(String key, Double defaultDouble) {
        try {
            return super.getDouble(key);
        }
        catch (JSONException e) {
            return defaultDouble;
        }
    }

    public Object get(String key) {
        try {
            return super.get(key);
        }
        catch (JSONException e) {
            Log.eToGaOnly(true, TAG, "Failed to read json key. " + String.format("[%s] : ", key), e);
            return null;
        }
    }

    public Map<String, String> toStringMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator it = this.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = "" + this.get(key);
            if (value.length() > 255) {
                value = value.substring(0, 255);
            }
            map.put(key, value);
        }
        return map;
    }

    public boolean equals(Object o) {
        if (!(o instanceof JSONObject)) {
            return false;
        }
        return EasyJSONObject.equals(this, (JSONObject)o);
    }

    public static boolean equals(Object oneVal, Object twoVal) {
        if (oneVal == null || twoVal == null) {
            return oneVal == twoVal;
        }
        if (oneVal instanceof JSONObject) {
            if (!(twoVal instanceof JSONObject)) {
                return false;
            }
            JSONObject oneValObject = (JSONObject)oneVal;
            JSONObject twoValObject = (JSONObject)twoVal;
            if (!EasyJSONObject.equals(oneValObject, twoValObject)) {
                return false;
            }
        } else if (oneVal instanceof JSONArray) {
            if (!(twoVal instanceof JSONArray)) {
                return false;
            }
            JSONArray oneValArray = (JSONArray)oneVal;
            JSONArray twoValArray = (JSONArray)twoVal;
            if (!EasyJSONObject.equals(oneValArray, twoValArray)) {
                return false;
            }
        } else if (!oneVal.equals(twoVal)) {
            return false;
        }
        return true;
    }

    public static boolean equals(JSONArray one, JSONArray two) {
        if (one == null || two == null) {
            return one == two;
        }
        if (one.length() != two.length()) {
            return false;
        }
        for (int i = 0; i < one.length(); ++i) {
            try {
                Object oneVal = one.get(i);
                Object twoVal = two.get(i);
                if (EasyJSONObject.equals(oneVal, twoVal)) continue;
                return false;
            }
            catch (JSONException e) {
                return false;
            }
        }
        return true;
    }

    public static boolean equals(JSONObject one, JSONObject two) {
        if (one == null || two == null) {
            return one == two;
        }
        if (one.length() != two.length()) {
            return false;
        }
        Iterator iterator = one.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (!two.has(key)) {
                return false;
            }
            try {
                Object twoVal;
                Object oneVal = one.get(key);
                if (EasyJSONObject.equals(oneVal, twoVal = two.get(key))) continue;
                return false;
            }
            catch (JSONException e) {
                return false;
            }
        }
        return true;
    }
}

