/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.analytics.flush;

import android.os.Handler;
import com.aniways.Log;
import com.aniways.analytics.NonThrowingRunnable;
import com.aniways.analytics.utils.LooperThreadWithHandler;
import com.aniways.data.AniwaysPrivateConfig;

public class FlushTimer
extends LooperThreadWithHandler {
    private Runnable clock;
    private boolean active;
    private static final String TAG = "AniwaysFlushTimer";
    private Runnable tick = new NonThrowingRunnable("AniwaysFlushTimer", "perform request in flush tick", "", true){

        @Override
        public void innerRun() {
            if (FlushTimer.this.active) {
                FlushTimer.this.clock.run();
                FlushTimer.this.scheduleTick();
            }
        }
    };

    public FlushTimer(Runnable clock) {
        super(TAG);
        this.clock = clock;
    }

    public synchronized void start() {
        super.start();
        try {
            this.active = true;
            this.scheduleTick();
        }
        catch (Throwable ex) {
            Log.eToGaOnly(true, TAG, "Caught Exception in start of flush timer", ex);
        }
    }

    public void scheduleNow() {
        this.scheduleTick(0);
    }

    private void scheduleTick() {
        this.scheduleTick(AniwaysPrivateConfig.getInstance().analyticsFlushInterval);
    }

    private void scheduleTick(int frequencyMs) {
        if (!this.active) {
            return;
        }
        Handler handler = this.handler();
        handler.postDelayed(this.tick, (long)frequencyMs);
    }

    public boolean quit() {
        this.active = false;
        return super.quit();
    }
}

