/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.analytics.db;

import com.aniways.Log;
import com.aniways.analytics.models.Alias;
import com.aniways.analytics.models.BasePayload;
import com.aniways.analytics.models.Error;
import com.aniways.analytics.models.Identify;
import com.aniways.analytics.models.Screen;
import com.aniways.analytics.models.Timing;
import com.aniways.analytics.models.Track;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonPayloadSerializer {
    private static final String TAG = "AniwaysJsonPayloadSerializer";

    public String serialize(BasePayload payload) {
        return payload.toString();
    }

    public BasePayload deseralize(String str) {
        try {
            JSONObject obj = new JSONObject(str);
            String type = obj.getString("type");
            if (type.equals("identify")) {
                return new Identify(obj);
            }
            if (type.equals("track")) {
                return new Track(obj);
            }
            if (type.equals("alias")) {
                return new Alias(obj);
            }
            if (type.equals("screen")) {
                return new Screen(obj);
            }
            if (type.equals("timing")) {
                return new Timing(obj);
            }
            if (type.equals("error")) {
                return new Error(obj);
            }
            if (type.equals("log")) {
                return new com.aniways.analytics.models.Log(obj);
            }
        }
        catch (JSONException e) {
            Log.eToGaOnly(true, TAG, "Failed to convert json to base payload: " + str, e);
        }
        return null;
    }
}

