/*
 * Decompiled with CFR 0.152.
 */
package com.aniways;

import android.annotation.SuppressLint;
import android.content.Context;
import com.aniways.Utils;
import com.aniways.analytics.AnalyticsReporter;
import com.aniways.data.AniwaysConfiguration;
import com.aniways.data.AniwaysPrivateConfig;
import java.util.ArrayList;
import java.util.Arrays;

public class Log {
    private static Context sContext;
    private static final String WARNING = "Warning";
    private static final String ERROR = "Error";
    private static final String ASSERT = "Assert";
    private static final String TAG = "AniwaysLog";

    public static int v(String tag, String msg) {
        if (AniwaysPrivateConfig.getLogsVerbosity().ordinal() <= AniwaysConfiguration.Verbosity.Verbose.ordinal()) {
            return android.util.Log.v((String)tag, (String)msg);
        }
        return 0;
    }

    public static int v(String tag, String msg, Throwable tr) {
        if (AniwaysPrivateConfig.getLogsVerbosity().ordinal() <= AniwaysConfiguration.Verbosity.Verbose.ordinal()) {
            return android.util.Log.v((String)tag, (String)msg, (Throwable)tr);
        }
        return 0;
    }

    public static int d(String tag, String msg) {
        if (AniwaysPrivateConfig.getLogsVerbosity().ordinal() <= AniwaysConfiguration.Verbosity.Debug.ordinal()) {
            return android.util.Log.d((String)tag, (String)msg);
        }
        return 0;
    }

    public static int d(String tag, String msg, Throwable tr) {
        if (AniwaysPrivateConfig.getLogsVerbosity().ordinal() <= AniwaysConfiguration.Verbosity.Debug.ordinal()) {
            return android.util.Log.d((String)tag, (String)msg, (Throwable)tr);
        }
        return 0;
    }

    public static int i(String tag, String msg) {
        if (AniwaysPrivateConfig.getLogsVerbosity().ordinal() <= AniwaysConfiguration.Verbosity.Info.ordinal()) {
            return android.util.Log.i((String)tag, (String)msg);
        }
        return 0;
    }

    public static int i(String tag, String msg, Throwable tr) {
        if (AniwaysPrivateConfig.getLogsVerbosity().ordinal() <= AniwaysConfiguration.Verbosity.Info.ordinal()) {
            return android.util.Log.i((String)tag, (String)msg, (Throwable)tr);
        }
        return 0;
    }

    public static int w(boolean sendToAnalytics, String tag, String msg) {
        return Log.w(sendToAnalytics, tag, msg, null);
    }

    public static int w(boolean sendToAnalytics, String tag, String msg, Throwable tr) {
        if (sendToAnalytics) {
            Log.reportToAnalytics(false, WARNING, tag, msg, tr);
        }
        if (AniwaysPrivateConfig.getLogsVerbosity().ordinal() <= AniwaysConfiguration.Verbosity.Info.ordinal()) {
            return android.util.Log.w((String)tag, (String)msg, (Throwable)tr);
        }
        return 0;
    }

    public static int wToGaOnly(boolean sendToAnalytics, String tag, String msg, Throwable tr) {
        if (sendToAnalytics) {
            Log.reportToAnalytics(true, WARNING, tag, msg, tr);
        }
        if (AniwaysPrivateConfig.getLogsVerbosity().ordinal() <= AniwaysConfiguration.Verbosity.Info.ordinal()) {
            return android.util.Log.w((String)tag, (String)msg, (Throwable)tr);
        }
        return 0;
    }

    public static int w(boolean sendToAnalytics, String tag, Throwable tr) {
        return Log.w(sendToAnalytics, tag, "", tr);
    }

    public static int e(boolean sendToAnalytics, String tag, String msg) {
        return Log.e(sendToAnalytics, tag, msg, null);
    }

    public static int e(boolean sendToAnalytics, String tag, String msg, Throwable tr) {
        try {
            if (sendToAnalytics) {
                Log.reportToAnalytics(false, ERROR, tag, msg, tr);
            }
            if (AniwaysPrivateConfig.getLogsVerbosity().ordinal() <= AniwaysConfiguration.Verbosity.Error.ordinal()) {
                return android.util.Log.e((String)tag, (String)msg, (Throwable)tr);
            }
        }
        catch (Throwable ex) {
            android.util.Log.e((String)TAG, (String)"Caught error while reporting an error", (Throwable)ex);
        }
        return 0;
    }

    public static int eToGaOnly(boolean sendToAnalytics, String tag, String msg, Throwable tr) {
        if (sendToAnalytics) {
            Log.reportToAnalytics(true, ERROR, tag, msg, tr);
        }
        if (AniwaysPrivateConfig.getLogsVerbosity().ordinal() <= AniwaysConfiguration.Verbosity.Error.ordinal()) {
            return android.util.Log.e((String)tag, (String)msg, (Throwable)tr);
        }
        return 0;
    }

    public static int wtf(String tag, String msg) {
        return Log.wtf(tag, msg, new Exception());
    }

    public static int wtf(String tag, Throwable tr) {
        return Log.wtf(tag, "", tr);
    }

    @SuppressLint(value={"NewApi"})
    public static int wtf(String tag, String msg, Throwable tr) {
        Log.reportToAnalytics(false, ASSERT, tag, msg, tr);
        if (Utils.isAndroidVersionAtLeast(8)) {
            if (AniwaysPrivateConfig.getLogsVerbosity().ordinal() <= AniwaysConfiguration.Verbosity.Error.ordinal()) {
                return android.util.Log.wtf((String)tag, (String)msg, (Throwable)tr);
            }
            return 0;
        }
        if (AniwaysPrivateConfig.getLogsVerbosity().ordinal() <= AniwaysConfiguration.Verbosity.Error.ordinal()) {
            return android.util.Log.e((String)tag, (String)msg, (Throwable)tr);
        }
        return 0;
    }

    public static String getStackTraceString(Throwable tr) {
        return android.util.Log.getStackTraceString((Throwable)tr);
    }

    public static void forceInit(Context context) {
        sContext = context;
    }

    private static void reportToAnalytics(boolean toGaOnly, String severity, String tag, String msg, Throwable tr) {
        AniwaysConfiguration.Verbosity verbosity;
        if (sContext == null) {
            android.util.Log.w((String)TAG, (String)("Trying to send log to GA before the Log was initialized. Severity: " + severity + " tag: " + tag + " msg: " + msg), (Throwable)tr);
            return;
        }
        if (tr == null) {
            tr = new Exception();
            StackTraceElement[] stackTrace = tr.getStackTrace();
            ArrayList<StackTraceElement> stackTraceList = new ArrayList<StackTraceElement>(Arrays.asList(stackTrace));
            for (StackTraceElement e : stackTrace) {
                if (!e.getClassName().equals(Log.class.getCanonicalName())) break;
                stackTraceList.remove(0);
            }
            tr.setStackTrace(stackTraceList.toArray(new StackTraceElement[stackTraceList.size()]));
        }
        if (severity.equalsIgnoreCase(ASSERT)) {
            verbosity = AniwaysConfiguration.Verbosity.Error;
        } else if (severity.equalsIgnoreCase(WARNING)) {
            verbosity = AniwaysConfiguration.Verbosity.Warning;
        } else if (severity.equalsIgnoreCase(ERROR)) {
            verbosity = AniwaysConfiguration.Verbosity.Error;
        } else {
            Log.e(true, TAG, "severity doesn't equal one of the 3 allowed one");
            verbosity = AniwaysConfiguration.Verbosity.Error;
        }
        if (AnalyticsReporter.isInitialized()) {
            AnalyticsReporter.reportError(verbosity, tag, msg, tr, toGaOnly);
        }
    }
}

