/*
 * Decompiled with CFR 0.152.
 */
package com.aniways;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.aniways.AniwaysEditText;
import com.aniways.AniwaysEmoticonsOnDemandButton;
import com.aniways.Log;
import com.aniways.R;
import com.aniways.ViewUtils;
import com.aniways.emoticons.button.AniwaysEmoticonsButtonMaker;
import java.util.List;

public class AniwaysVerticalLinearLayout
extends LinearLayout {
    private static final String TAG = "AniwaysVerticalLinearLayout";
    private LinearLayout mPlaceholder;
    private AniwaysEditText mEditText;
    private AniwaysEmoticonsOnDemandButton mButton;
    private boolean mSuccessfullyCreatedButton = false;

    public AniwaysVerticalLinearLayout(Context context) {
        this(context, null);
    }

    public AniwaysVerticalLinearLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        if (!this.isInEditMode()) {
            // empty if block
        }
        this.init(context);
    }

    @SuppressLint(value={"NewApi"})
    public AniwaysVerticalLinearLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    private void init(Context context) {
        this.setOrientation(1);
        LinearLayout placeholder = (LinearLayout)LayoutInflater.from((Context)context).inflate(R.layout.aniways_emoticons_button_popup_placeholder, null);
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -2);
        this.addView((View)placeholder, params);
        this.mPlaceholder = placeholder;
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        int numChildren = this.getChildCount();
        if (index == numChildren || index < 0) {
            index = numChildren - 1;
        }
        super.addView(child, index, params);
    }

    LinearLayout getPlaceholder() {
        return this.mPlaceholder;
    }

    AniwaysEditText getAniwaysEditText() {
        if (this.mEditText != null) {
            return this.mEditText;
        }
        List<AniwaysEditText> editTexts = ViewUtils.find((ViewGroup)this, AniwaysEditText.class);
        if (editTexts == null || editTexts.isEmpty()) {
            return null;
        }
        return editTexts.get(0);
    }

    AniwaysEmoticonsOnDemandButton getEmoticonsButton() {
        if (this.mButton != null) {
            return this.mButton;
        }
        List<AniwaysEmoticonsOnDemandButton> buttons = ViewUtils.find((ViewGroup)this, AniwaysEmoticonsOnDemandButton.class);
        if (buttons == null || buttons.isEmpty()) {
            return null;
        }
        return buttons.get(0);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        Log.i(TAG, "Finished inflating");
        if (!this.isInEditMode()) {
            this.mSuccessfullyCreatedButton = new AniwaysEmoticonsButtonMaker().makeButtonAniwaysEmoticonsButton((View)this.getEmoticonsButton(), this.getPlaceholder(), (ViewGroup)this, this.getAniwaysEditText(), null, false);
            Log.v(TAG, "Finished inflate. Result: " + this.mSuccessfullyCreatedButton);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode() && !this.mSuccessfullyCreatedButton) {
            this.mSuccessfullyCreatedButton = new AniwaysEmoticonsButtonMaker().makeButtonAniwaysEmoticonsButton((View)this.getEmoticonsButton(), this.getPlaceholder(), (ViewGroup)this, this.getAniwaysEditText(), null, false);
            Log.v(TAG, "Finished attaching. Result: " + this.mSuccessfullyCreatedButton);
        }
    }

    static class LayoutTraverser {
        private final Processor processor;

        private LayoutTraverser(Processor processor) {
            this.processor = processor;
        }

        public static LayoutTraverser build(Processor processor) {
            return new LayoutTraverser(processor);
        }

        public void traverse(ViewGroup root, boolean firstPass) {
            int childCount = root.getChildCount();
            if (firstPass) {
                this.processor.process((View)root);
            }
            for (int i = 0; i < childCount; ++i) {
                View child = root.getChildAt(i);
                this.processor.process(child);
                if (!(child instanceof ViewGroup)) continue;
                this.traverse((ViewGroup)child, false);
            }
        }

        public static interface Processor {
            public void process(View var1);
        }
    }
}

