/*
 * Decompiled with CFR 0.152.
 */
package com.aniways;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Handler;
import android.os.Looper;
import android.text.Spannable;
import android.text.TextUtils;
import android.text.style.ReplacementSpan;
import android.view.View;
import android.widget.TextView;
import com.aniways.AniwaysDynamicImageSpansContainer;
import com.aniways.AniwaysImageSpan;
import com.aniways.IAniwaysDynamicImageSpan;
import com.aniways.IAniwaysImageSpan;
import com.aniways.IIconInfoDisplayer;
import com.aniways.IconData;
import com.aniways.Log;
import com.aniways.R;
import com.aniways.analytics.NonThrowingRunnable;
import com.aniways.data.AniwaysNetworkStateChecker;
import com.aniways.data.Phrase;
import com.aniways.volley.VolleyError;
import com.aniways.volley.toolbox.IResponseListener;
import com.aniways.volley.toolbox.ImageLoader;
import java.util.HashMap;
import java.util.Iterator;

public class AniwaysLoadingImageSpan
extends ReplacementSpan
implements IAniwaysDynamicImageSpan {
    protected static final String TAG = "AniwaysLoadingImageSpan";
    private int mMaxWidth;
    private int mMaxHeight;
    private String mUrl;
    private ImageLoader mImageLoader;
    private ImageLoader.ImageContainer mImageContainer;
    private HashMap<AniwaysDynamicImageSpansContainer, IResponseListener> mRequestListeners = new HashMap();
    private Phrase mPhrase;
    private IconData mIcon;
    private IAniwaysImageSpan.ImageSpanMetadata mImageSpanMetadata;
    private Handler mHandler = new Handler(Looper.getMainLooper());
    private int mMaxWidthForCache;
    private int mMaxHeightForCache;
    protected View textView;
    private boolean mListenerRegistered = false;
    protected Object mData;

    public AniwaysLoadingImageSpan(int maxWidth, int maxHeight, Context ctx, Phrase phrase, IconData icon, IAniwaysImageSpan.ImageSpanMetadata imageSpanMetadata, float textSizeRawPixels) {
        TextView button = new TextView(ctx);
        button.setText((CharSequence)phrase.getPartToReplace());
        if (textSizeRawPixels > 0.0f) {
            button.setTextSize(0, textSizeRawPixels);
        }
        button.setBackgroundColor(ctx.getResources().getColor(R.color.aniways_transparent));
        this.textView = button;
        this.mMaxWidth = maxWidth;
        this.mMaxHeight = maxHeight;
        this.mIcon = icon;
        this.mPhrase = phrase;
        this.mImageSpanMetadata = imageSpanMetadata;
    }

    private void prepView() {
        int widthSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int heightSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        this.textView.measure(widthSpec, heightSpec);
        this.textView.layout(0, 0, this.textView.getMeasuredWidth(), this.textView.getMeasuredHeight());
    }

    public void draw(Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, Paint paint) {
        this.prepView();
        canvas.save();
        canvas.translate(x, (float)(bottom - this.textView.getBottom()));
        this.textView.draw(canvas);
        canvas.restore();
    }

    public int getSize(Paint paint, CharSequence charSequence, int i, int i2, Paint.FontMetricsInt fm) {
        int height;
        int need;
        this.prepView();
        if (fm != null && (need = (height = this.textView.getMeasuredHeight()) - (fm.descent - fm.ascent)) > 0) {
            int ascent = need / 2;
            fm.descent += need - ascent;
            fm.ascent -= ascent;
            fm.bottom += need - ascent;
            fm.top -= need / 2;
        }
        return this.textView.getRight();
    }

    public void setImageUrl(String url, ImageLoader imageLoader, int maxWidthForCache, int maxHeightForCache) {
        this.mUrl = url;
        this.mImageLoader = imageLoader;
        this.mMaxWidthForCache = maxWidthForCache;
        this.mMaxHeightForCache = maxHeightForCache;
    }

    public void registerResponseListener(AniwaysDynamicImageSpansContainer key, IResponseListener responseListener) {
        Log.d(TAG, "Registering response listener. Url: " + this.mUrl);
        this.mRequestListeners.put(key, responseListener);
        this.mListenerRegistered = true;
    }

    public void unregisterResponseListener(AniwaysDynamicImageSpansContainer key) {
        Log.d(TAG, "Un-Registering response listener. Before remove: " + this.mRequestListeners.size() + " .Url: " + this.mUrl);
        IResponseListener removed = this.mRequestListeners.remove(key);
        Log.d(TAG, "After remove: " + this.mRequestListeners.size() + ". Removed: " + (removed != null) + " .Url: " + this.mUrl);
    }

    void loadImageIfNecessary(final boolean isInLayoutPass) {
        ImageLoader.ImageContainer newContainer;
        if (TextUtils.isEmpty((CharSequence)this.mUrl)) {
            if (this.mImageContainer != null) {
                this.mImageContainer.cancelRequest();
                this.mImageContainer = null;
            }
            this.setDefaultImageOrNull();
            return;
        }
        if (this.mImageContainer != null && this.mImageContainer.getRequestUrl() != null) {
            if (this.mImageContainer.getRequestUrl().equals(this.mUrl)) {
                return;
            }
            this.mImageContainer.cancelRequest();
            this.setDefaultImageOrNull();
        }
        this.mImageContainer = newContainer = this.mImageLoader.get(this.mUrl, new ImageLoader.ImageListener(){

            @Override
            public void onErrorResponse(final VolleyError error) {
                try {
                    AniwaysNetworkStateChecker.checkInternet(new AniwaysNetworkStateChecker.AniwaysNetworkSateCheckCallback(){

                        @Override
                        public void run(boolean connectionAvailable) {
                            if (connectionAvailable) {
                                Log.e(true, AniwaysLoadingImageSpan.TAG, "Error loading image from url: " + AniwaysLoadingImageSpan.this.mUrl + ". Error: " + error.getMessage(), error);
                            } else {
                                Log.w(false, AniwaysLoadingImageSpan.TAG, "Error loading image, but its OK since there us no internet connection. Url: " + AniwaysLoadingImageSpan.this.mUrl + ". Error: " + error.getMessage(), error);
                            }
                        }
                    });
                    for (IResponseListener listener : AniwaysLoadingImageSpan.this.mRequestListeners.values()) {
                        listener.onError();
                    }
                }
                catch (Throwable tr) {
                    Log.e(true, AniwaysLoadingImageSpan.TAG, "Caught exception in onErrorResponse. Url: " + AniwaysLoadingImageSpan.this.mUrl, tr);
                }
            }

            @Override
            public void onResponse(final ImageLoader.ImageContainer response, final boolean isImmediate) {
                try {
                    if (isImmediate && isInLayoutPass) {
                        if (response.getBitmap() == null && response.getRawData() == null) {
                            return;
                        }
                        AniwaysLoadingImageSpan.this.mHandler.post((Runnable)new NonThrowingRunnable(AniwaysLoadingImageSpan.TAG, "onResponse", ""){

                            @Override
                            public void innerRun() {
                                this.responseInternal(response, isImmediate);
                            }
                        });
                        return;
                    }
                    this.responseInternal(response, isImmediate);
                }
                catch (Throwable tr) {
                    try {
                        Log.e(true, AniwaysLoadingImageSpan.TAG, "Caught exception in onResponse. Url: " + AniwaysLoadingImageSpan.this.mUrl, tr);
                        for (IResponseListener listener : AniwaysLoadingImageSpan.this.mRequestListeners.values()) {
                            listener.onError();
                        }
                    }
                    catch (Throwable tr2) {
                        Log.e(true, AniwaysLoadingImageSpan.TAG, "Caught exception in onResponse error response. Url: " + AniwaysLoadingImageSpan.this.mUrl, tr2);
                    }
                }
            }

            /*
             * Enabled aggressive block sorting
             */
            void responseInternal(ImageLoader.ImageContainer response, boolean wasImmediate) {
                Iterator i$;
                block18: {
                    if (AniwaysLoadingImageSpan.this.mIcon != null && AniwaysLoadingImageSpan.this.mIcon.isAnimated()) {
                        byte[] data = response.getRawData();
                        if (data == null) {
                            if (wasImmediate) {
                                Log.v(AniwaysLoadingImageSpan.TAG, "Received immediate null response for animated gif: " + AniwaysLoadingImageSpan.this.mUrl);
                                return;
                            }
                            Log.w(true, AniwaysLoadingImageSpan.TAG, "Received non-immediate null response for animated gif: " + AniwaysLoadingImageSpan.this.mUrl);
                            Iterator i$2 = AniwaysLoadingImageSpan.this.mRequestListeners.values().iterator();
                            while (i$2.hasNext()) {
                                IResponseListener listener = (IResponseListener)i$2.next();
                                listener.onError();
                            }
                            return;
                        }
                        if (data instanceof byte[]) {
                            AniwaysLoadingImageSpan.this.mData = data;
                            break block18;
                        } else {
                            Log.e(true, AniwaysLoadingImageSpan.TAG, "Received non byte array for animated gif: " + AniwaysLoadingImageSpan.this.mUrl);
                            Iterator i$3 = AniwaysLoadingImageSpan.this.mRequestListeners.values().iterator();
                            while (i$3.hasNext()) {
                                IResponseListener listener = (IResponseListener)i$3.next();
                                listener.onError();
                            }
                            return;
                        }
                    }
                    if (response.getRawData() != null) {
                        AniwaysLoadingImageSpan.this.mData = response.getRawData();
                    } else if (response.getBitmap() != null) {
                        AniwaysLoadingImageSpan.this.mData = response.getBitmap();
                    } else if (response.getBitmap() == null) {
                        if (wasImmediate) {
                            Log.v(AniwaysLoadingImageSpan.TAG, "Received immediate null response for bitmap: " + AniwaysLoadingImageSpan.this.mUrl);
                            return;
                        }
                        Log.e(true, AniwaysLoadingImageSpan.TAG, "Bitmap is null. Url: " + AniwaysLoadingImageSpan.this.mUrl);
                        Iterator i$4 = AniwaysLoadingImageSpan.this.mRequestListeners.values().iterator();
                        while (i$4.hasNext()) {
                            IResponseListener listener = (IResponseListener)i$4.next();
                            listener.onError();
                        }
                        return;
                    }
                }
                if (AniwaysLoadingImageSpan.this.mData != null) {
                    if (AniwaysLoadingImageSpan.this.mRequestListeners.size() <= 0) {
                        Log.w(true, AniwaysLoadingImageSpan.TAG, "No listeners. Was registered at least once: " + AniwaysLoadingImageSpan.this.mListenerRegistered + ". Url: " + AniwaysLoadingImageSpan.this.mUrl);
                        AniwaysLoadingImageSpan.this.mHandler.post((Runnable)new NonThrowingRunnable(AniwaysLoadingImageSpan.TAG, "detatching from window", ""){

                            @Override
                            public void innerRun() {
                                AniwaysLoadingImageSpan.this.onDetachedFromWindowCalled();
                            }
                        });
                        return;
                    }
                    i$ = AniwaysLoadingImageSpan.this.mRequestListeners.values().iterator();
                    while (i$.hasNext()) {
                        IResponseListener listener = (IResponseListener)i$.next();
                        listener.onSuccess();
                    }
                    return;
                }
                Log.e(true, AniwaysLoadingImageSpan.TAG, "Data is null. Url: " + AniwaysLoadingImageSpan.this.mUrl);
                i$ = AniwaysLoadingImageSpan.this.mRequestListeners.values().iterator();
                while (i$.hasNext()) {
                    IResponseListener listener = (IResponseListener)i$.next();
                    listener.onError();
                }
            }
        }, this.mMaxWidthForCache, this.mMaxHeightForCache, false);
    }

    boolean replaceWithImageSpan(Spannable spannable, Context ctx, IIconInfoDisplayer iconInfoDisplayer, AniwaysDynamicImageSpansContainer dynamicSpansContainer) {
        int start = spannable.getSpanStart((Object)this);
        int end = spannable.getSpanEnd((Object)this);
        if (start < 0 || end < 0) {
            Log.v(TAG, "Span is not in the spannable. Url: " + this.mUrl);
            return false;
        }
        AniwaysImageSpan is = this.mIcon.createImageSpan(this.mData, this.mPhrase, this.mImageSpanMetadata.iconSelectionOrigin, ctx, this.mMaxWidth, this.mMaxHeight, iconInfoDisplayer);
        if (is instanceof IAniwaysDynamicImageSpan) {
            dynamicSpansContainer.addDynamicImageSpan((IAniwaysDynamicImageSpan)((Object)is));
        }
        spannable.setSpan((Object)is, start, end, 33);
        spannable.removeSpan((Object)this);
        return true;
    }

    private void setDefaultImageOrNull() {
    }

    @Override
    public void onLayoutCalled() {
        Log.d(TAG, "layout called. Url: " + this.mUrl);
        this.loadImageIfNecessary(true);
    }

    @Override
    public void onDetachedFromWindowCalled() {
        Log.d(TAG, "detach called. Url: " + this.mUrl);
        if (this.mRequestListeners.size() > 0) {
            Log.d(TAG, "Not detaching cause this span is still hooked to something. Url: " + this.mUrl);
            return;
        }
        if (this.mImageContainer != null) {
            this.mImageContainer.cancelRequest();
            this.mImageContainer = null;
        }
    }

    @Override
    public Phrase getPhrase() {
        return this.mPhrase;
    }

    @Override
    public IconData getIcon() {
        return this.mIcon;
    }

    @Override
    public IAniwaysImageSpan.ImageSpanMetadata getImageSpanMetadata() {
        return this.mImageSpanMetadata;
    }

    @Override
    public boolean isLoadingImageSpan() {
        return true;
    }

    @Override
    public void onAddedToContainer(AniwaysDynamicImageSpansContainer container) {
        this.loadImageIfNecessary(false);
    }

    @Override
    public void onRemovedFromContainer(AniwaysDynamicImageSpansContainer aniwaysDynamicImageSpansContainer) {
        this.unregisterResponseListener(aniwaysDynamicImageSpansContainer);
        this.onDetachedFromWindowCalled();
    }
}

