/*
 * Decompiled with CFR 0.152.
 */
package com.aniways;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.text.Editable;
import com.aniways.AniwaysDynamicImageSpansContainer;
import com.aniways.AniwaysImageSpan;
import com.aniways.IAniwaysDynamicImageSpan;
import com.aniways.IAniwaysImageSpan;
import com.aniways.IconData;
import com.aniways.Log;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.data.Phrase;
import com.aniways.nineoldandroids.animation.ObjectAnimator;
import com.aniways.nineoldandroids.animation.ValueAnimator;

public class AniwaysInteractiveImageSpan
extends AniwaysImageSpan
implements IAniwaysDynamicImageSpan {
    private static final String TAG = "AniwaysAnimatedImageSpan";
    private final Editable mText;
    private float factor = 1.0f;
    private ObjectAnimator mSpanAnimation;

    public AniwaysInteractiveImageSpan(Bitmap image, Phrase phrase, IconData icon, IAniwaysImageSpan.IconSelectionOrigin selectionOrigin, Context context, int width, int height, Editable text) {
        super(image, phrase, icon, selectionOrigin, context, width, height);
        this.mText = text;
        this.animate();
    }

    public void draw(Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, Paint paint) {
        canvas.save();
        int transY = bottom - this.getDrawable().getBounds().bottom;
        if (this.mVerticalAlignment == 1) {
            transY -= paint.getFontMetricsInt().descent;
        }
        canvas.translate(x, (float)transY);
        Rect bounds = this.getDrawable().getBounds();
        canvas.scale(this.factor, this.factor, (float)(bounds.left + bounds.width() / 2), (float)(bounds.top + bounds.height() / 2));
        this.getDrawable().draw(canvas);
        canvas.restore();
    }

    public void setPulsate(float step) {
        this.factor = step / 100.0f;
    }

    private void animate() {
        try {
            int pulsateAnimationFrom = AniwaysPrivateConfig.getInstance().pulsateAnimationFrom;
            int pulsateAnimationTo = AniwaysPrivateConfig.getInstance().pulsateAnimationTo;
            float[] values = new float[]{pulsateAnimationFrom, pulsateAnimationTo};
            this.mSpanAnimation = ObjectAnimator.ofFloat(this, "Pulsate", values);
            this.mSpanAnimation.setDuration(AniwaysPrivateConfig.getInstance().pulsateAnimationDuration);
            this.mSpanAnimation.setRepeatCount(AniwaysPrivateConfig.getInstance().pulsateAnimationRepeatCount);
            this.mSpanAnimation.setRepeatMode(2);
            this.mSpanAnimation.start();
            this.mSpanAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                @Override
                public void onAnimationUpdate(ValueAnimator arg0) {
                    try {
                        AniwaysInteractiveImageSpan.this.invalidateSelf();
                    }
                    catch (Throwable t) {
                        Log.e(true, AniwaysInteractiveImageSpan.TAG, "Exception when invalidating self", t);
                    }
                }
            });
        }
        catch (Throwable t) {
            Log.e(true, TAG, "Exception when animating span", t);
        }
    }

    private void stopAnimation() {
        this.mSpanAnimation.cancel();
    }

    private void invalidateSelf() {
        int end = this.mText.getSpanEnd((Object)this);
        int start = this.mText.getSpanStart((Object)this);
        if (start == -1 || end == -1) {
            return;
        }
        this.mText.removeSpan((Object)this);
        this.mText.setSpan((Object)this, start, end, 33);
    }

    @Override
    public void onDetachedFromWindowCalled() {
        Log.d(TAG, "detach called on interactive span. phrase: " + this.getPhrase() + ", iconId: " + this.getIcon().id);
        this.stopAnimation();
    }

    @Override
    public void onLayoutCalled() {
        Log.d(TAG, "layout called on interactive span. phrase: " + this.getPhrase() + ", iconId: " + this.getIcon().id);
        this.animate();
    }

    @Override
    public void onAddedToContainer(AniwaysDynamicImageSpansContainer container) {
    }

    @Override
    public void onRemovedFromContainer(AniwaysDynamicImageSpansContainer aniwaysDynamicImageSpansContainer) {
    }
}

