/*
 * Decompiled with CFR 0.152.
 */
package com.aniways;

import android.view.GestureDetector;
import android.view.MotionEvent;
import com.aniways.IAniwaysGestureResponder;
import com.aniways.Log;
import java.util.ArrayList;
import java.util.List;

class AniwaysGestureListener
extends GestureDetector.SimpleOnGestureListener {
    private List<MotionEvent> mRecordedEvents;
    private IAniwaysGestureResponder mGestureResponder;
    private boolean mRecordEvents = false;
    private static final String TAG = "AniwaysGestureListener";

    public AniwaysGestureListener(IAniwaysGestureResponder gestureResponder) {
        this.mGestureResponder = gestureResponder;
        this.mRecordedEvents = new ArrayList<MotionEvent>();
    }

    public boolean onDown(MotionEvent event) {
        return true;
    }

    public boolean onSingleTapUp(MotionEvent event) {
        Log.d(TAG, "In onSingleTapUp. Action: " + event.getAction() + " Recording Events: " + this.ismRecordEvents());
        return true;
    }

    public boolean onSingleTapConfirmed(MotionEvent event) {
        Log.d(TAG, "In onSingleTapConfirmed. Action: " + event.getAction() + " Recording Events: " + this.ismRecordEvents());
        this.mGestureResponder.onSingleTap(event);
        this.clearRecordedEvents();
        return true;
    }

    public boolean onDoubleTapEvent(MotionEvent event) {
        return true;
    }

    public boolean onDoubleTap(MotionEvent event) {
        Log.d(TAG, "In onDoubleTap. Action: " + event.getAction() + " Recording Events: " + this.ismRecordEvents());
        this.playBackEventsIfRecording();
        return true;
    }

    public void onLongPress(MotionEvent event) {
        Log.d(TAG, "In onLongPress. Action: " + event.getAction() + " Recording Events: " + this.ismRecordEvents());
        this.playBackEventsIfRecording();
    }

    public void onShowPress(MotionEvent event) {
        Log.d(TAG, "In onShowPress. Action: " + event.getAction() + " Recording Events: " + this.ismRecordEvents());
    }

    public boolean ismRecordEvents() {
        return this.mRecordEvents;
    }

    public void setRecordEvents(boolean recordEvents) {
        this.mRecordEvents = recordEvents;
        if (!recordEvents) {
            this.clearRecordedEvents();
        }
    }

    public void recordEvent(MotionEvent event) {
        this.mRecordedEvents.add(MotionEvent.obtain((MotionEvent)event));
    }

    private void clearRecordedEvents() {
        if (this.mRecordedEvents == null || this.mRecordedEvents.isEmpty()) {
            return;
        }
        for (MotionEvent event : this.mRecordedEvents) {
            event.recycle();
        }
        Log.d(TAG, "Clearing recorded events..");
        this.mRecordedEvents.clear();
        this.mRecordEvents = false;
    }

    private void playBackEventsIfRecording() {
        if (this.ismRecordEvents()) {
            for (MotionEvent moEvent : this.mRecordedEvents) {
                Log.d(TAG, "Sending event to super. Action: " + moEvent.getAction());
                this.mGestureResponder.callSuperOnTouchEvent(moEvent);
            }
        }
        this.clearRecordedEvents();
    }
}

