/*
 * Decompiled with CFR 0.152.
 */
package com.aniways;

import android.text.TextUtils;
import com.aniways.data.AniwaysPhraseReplacementData;
import com.aniways.data.JsonParser;
import com.aniways.data.Phrase;
import com.aniways.data.PhrasesHashSet;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AniwaysCommercialPhraseMatcher {
    private static AniwaysCommercialPhraseMatcher instance;
    private String mCommercialPharsePatternString = null;
    private Pattern mCommercialPharsePattern = null;

    private AniwaysCommercialPhraseMatcher() {
    }

    public static AniwaysCommercialPhraseMatcher getInstance() {
        if (instance == null) {
            instance = new AniwaysCommercialPhraseMatcher();
        }
        return instance;
    }

    public Phrase isMatch(String text) {
        Phrase match = null;
        if (text == null || TextUtils.isEmpty((CharSequence)text)) {
            return null;
        }
        JsonParser parser = AniwaysPhraseReplacementData.getDataParser();
        if (parser == null) {
            return null;
        }
        this.buildCommercialPhrasesPattern(parser);
        if (this.mCommercialPharsePattern == null) {
            return null;
        }
        Matcher matcher = this.mCommercialPharsePattern.matcher(text);
        while (matcher.find()) {
            String matchedPhrase = matcher.group(0);
            if (TextUtils.isEmpty((CharSequence)matchedPhrase)) continue;
            match = parser.getCommercialPhrases().get(matchedPhrase.toLowerCase(Locale.US));
            break;
        }
        return match;
    }

    private void buildCommercialPhrasesPattern(JsonParser parser) {
        PhrasesHashSet commercialPhrases = parser.getCommercialPhrases();
        if (commercialPhrases == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (Phrase phrase : commercialPhrases) {
            sb.append(Pattern.quote(phrase.getName()));
            sb.append("|");
        }
        sb.deleteCharAt(sb.length() - 1);
        String pattern = "(\\b|\\B(?=\\W))(" + sb.toString() + ")(\\b|\\B(?=\\W)|$)";
        if (this.mCommercialPharsePatternString == null || !this.mCommercialPharsePatternString.equals(pattern)) {
            this.mCommercialPharsePatternString = pattern;
            this.mCommercialPharsePattern = Pattern.compile(this.mCommercialPharsePatternString, 2);
        }
    }
}

