/*
 * Decompiled with CFR 0.152.
 */
package com.aniways;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.aniways.Log;
import com.aniways.data.AniwaysPrivateConfig;
import java.io.InputStream;

public class AniwaysBitmapDecodeUtils {
    private static final String TAG = "AniwaysBitmapDecodeUtils";

    public static Bitmap decodeBitmapFromByteArray(byte[] array, int maxWidth, int maxHeight, String imageName, boolean isFromNetwork) {
        BitmapFactory.Options outOptions = new BitmapFactory.Options();
        outOptions.inJustDecodeBounds = true;
        if (array == null) {
            Log.w(true, TAG, "Null byte array, image name is:" + imageName + " . image is from network:" + isFromNetwork + ". maxWidth: " + maxWidth + " maxHeight: " + maxHeight);
        }
        BitmapFactory.decodeByteArray((byte[])array, (int)0, (int)array.length, (BitmapFactory.Options)outOptions);
        BitmapFactory.Options inOptions = AniwaysBitmapDecodeUtils.getInOptions(maxWidth, maxHeight, outOptions);
        Bitmap result = BitmapFactory.decodeByteArray((byte[])array, (int)0, (int)array.length, (BitmapFactory.Options)inOptions);
        Log.v(TAG, "Decoded width: " + inOptions.outWidth + " decoded height: " + inOptions.outHeight);
        if (result == null) {
            Log.w(true, TAG, "Could not deode image from byte array, image name is:" + imageName + " . image is from network:" + isFromNetwork + " Decoded width: " + inOptions.outWidth + " decoded height: " + inOptions.outHeight + ". maxWidth: " + maxWidth + " maxHeight: " + maxHeight + " origWidth: " + outOptions.outWidth + " origHeight: " + outOptions.outHeight);
        }
        return result;
    }

    public static Bitmap decodeBitmapFromStream(InputStream stream, int maxWidth, int maxHeight, String imageName, boolean isFromNetwork) {
        return AniwaysBitmapDecodeUtils.decodeBitmapFromStream(stream, stream, maxWidth, maxHeight, imageName, isFromNetwork);
    }

    public static Bitmap decodeBitmapFromStream(InputStream stream, InputStream streamForDecodeBounds, int maxWidth, int maxHeight, String imageName, boolean isFromNetwork) {
        BitmapFactory.Options outOptions = new BitmapFactory.Options();
        outOptions.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)streamForDecodeBounds, null, (BitmapFactory.Options)outOptions);
        BitmapFactory.Options inOptions = AniwaysBitmapDecodeUtils.getInOptions(maxWidth, maxHeight, outOptions);
        Bitmap result = BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)inOptions);
        Log.v(TAG, "Decoded width: " + inOptions.outWidth + " decoded height: " + inOptions.outHeight);
        if (result == null) {
            Log.w(true, TAG, "Could not deode image from stream, image name is:" + imageName + " . image is from network:" + isFromNetwork + " Decoded width: " + inOptions.outWidth + " decoded height: " + inOptions.outHeight + ". maxWidth: " + maxWidth + " maxHeight: " + maxHeight + " origWidth: " + outOptions.outWidth + " origHeight: " + outOptions.outHeight);
        }
        return result;
    }

    private static BitmapFactory.Options getInOptions(int maxWidth, int maxHeight, BitmapFactory.Options outOptions) {
        int sampleSize = 1;
        if (maxHeight != 0 || maxWidth != 0) {
            sampleSize = AniwaysBitmapDecodeUtils.calculateInSampleSize(outOptions, maxWidth, maxHeight);
        }
        Log.v(TAG, "Calculated sample size to be: " + sampleSize + " maxWidth: " + maxWidth + " maxHeight: " + maxHeight + " origWidth: " + outOptions.outWidth + " origHeight: " + outOptions.outHeight);
        BitmapFactory.Options inOptions = new BitmapFactory.Options();
        inOptions.inInputShareable = true;
        inOptions.inPurgeable = true;
        inOptions.inSampleSize = sampleSize;
        inOptions.inJustDecodeBounds = false;
        if (AniwaysPrivateConfig.getInstance().isLowMemoryDevice()) {
            inOptions.inPreferredConfig = Bitmap.Config.ARGB_4444;
        }
        return inOptions;
    }

    private static int calculateInSampleSize(BitmapFactory.Options options, int maxWidth, int maxHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        if (maxWidth == 0) {
            maxWidth = width;
        }
        if (maxHeight == 0) {
            maxHeight = height;
        }
        int inSampleSize = 1;
        if (height > maxHeight || width > maxWidth) {
            int widthRatio;
            int heightRatio = (int)Math.floor((float)height / (float)maxHeight);
            inSampleSize = heightRatio < (widthRatio = (int)Math.floor((float)width / (float)maxWidth)) ? widthRatio : heightRatio;
        }
        return Math.min(inSampleSize, AniwaysPrivateConfig.getInstance().maxInSampleSize);
    }
}

