/*
 * Decompiled with CFR 0.152.
 */
package com.aniways;

import android.annotation.SuppressLint;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import com.aniways.AniwaysDynamicImageSpansContainer;
import com.aniways.AniwaysImageSpan;
import com.aniways.IAniwaysDynamicImageSpan;
import com.aniways.IAniwaysImageSpan;
import com.aniways.IconData;
import com.aniways.Log;
import com.aniways.data.Phrase;
import java.util.HashMap;
import pl.droidsonroids.gif.GifDrawable;

public class AniwaysAnimatedGifSpan
extends AniwaysImageSpan
implements IAniwaysDynamicImageSpan,
Drawable.Callback {
    private static final String TAG = "AniwaysAnimatedImageSpan";
    private HashMap<AniwaysDynamicImageSpansContainer, IAniwaysDynamicImageSpan.InvalidateListener> mInvalidateListeners = new HashMap();
    private Handler mHandler = new Handler(Looper.getMainLooper());

    public AniwaysAnimatedGifSpan(byte[] data, Phrase phrase, IconData icon, IAniwaysImageSpan.IconSelectionOrigin selectionOrigin, int maxWidth, int maxHeight) {
        super(IconData.generateAnimatedDrawable(data), phrase, icon, selectionOrigin, maxWidth, maxHeight);
        Drawable drawable2 = this.getDrawable();
        if (drawable2 != null) {
            drawable2.setCallback((Drawable.Callback)this);
        }
    }

    @SuppressLint(value={"WrongCall"})
    private void startAnimation() {
        Drawable drawable2 = this.getDrawable();
        if (drawable2 == null) {
            Log.w(true, TAG, "Trying to start Animation, but drawable is null");
            return;
        }
        if (drawable2 instanceof GifDrawable) {
            GifDrawable gifDrawable = (GifDrawable)drawable2;
            if (!gifDrawable.isRunning()) {
                for (IAniwaysDynamicImageSpan.InvalidateListener listener : this.mInvalidateListeners.values()) {
                    listener.onDraw();
                }
                gifDrawable.start();
            }
        } else {
            Log.w(true, TAG, "Animation drawable is not GifDrawable");
        }
    }

    private void stopAnimation() {
        Drawable drawable2 = this.getDrawable();
        if (drawable2 == null) {
            Log.w(true, TAG, "Trying to stop Animation, but drawable is null");
            return;
        }
        if (drawable2 instanceof GifDrawable) {
            GifDrawable gifDrawable = (GifDrawable)drawable2;
            if (gifDrawable.isRunning()) {
                gifDrawable.stop();
            }
        } else {
            Log.w(true, TAG, "Animation drawable is not GifDrawable");
        }
    }

    public void registerInvalidateListener(AniwaysDynamicImageSpansContainer key, IAniwaysDynamicImageSpan.InvalidateListener invalidateListener) {
        Log.d(TAG, "Registering invalidate listener");
        this.mInvalidateListeners.put(key, invalidateListener);
    }

    public void unregisterInvalidateListener(AniwaysDynamicImageSpansContainer key) {
        Log.d(TAG, "Un-Registering invalidate listener. Before remove: " + this.mInvalidateListeners.size());
        IAniwaysDynamicImageSpan.InvalidateListener removed = this.mInvalidateListeners.remove(key);
        Log.d(TAG, "After remove: " + this.mInvalidateListeners.size() + ". Removed: " + (removed != null));
    }

    @Override
    public void onDetachedFromWindowCalled() {
        if (this.mInvalidateListeners.size() > 1) {
            return;
        }
        this.stopAnimation();
    }

    @Override
    public void onLayoutCalled() {
        this.startAnimation();
    }

    public void invalidateDrawable(Drawable who) {
        for (IAniwaysDynamicImageSpan.InvalidateListener listener : this.mInvalidateListeners.values()) {
            listener.invalidate(this);
        }
    }

    public void scheduleDrawable(Drawable who, Runnable what, long when) {
        this.mHandler.postAtTime(what, (Object)who, when);
    }

    public void unscheduleDrawable(Drawable who, Runnable what) {
        this.mHandler.removeCallbacks(what, (Object)who);
    }

    @Override
    public void onAddedToContainer(AniwaysDynamicImageSpansContainer container) {
        this.startAnimation();
    }

    @Override
    public void onRemovedFromContainer(AniwaysDynamicImageSpansContainer aniwaysDynamicImageSpansContainer) {
        this.unregisterInvalidateListener(aniwaysDynamicImageSpansContainer);
        if (this.mInvalidateListeners.size() < 1) {
            this.onDetachedFromWindowCalled();
        }
    }

    @SuppressLint(value={"WrongCall"})
    public void draw(Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, Paint paint) {
        super.draw(canvas, text, start, end, x, top, y, bottom, paint);
        for (IAniwaysDynamicImageSpan.InvalidateListener listener : this.mInvalidateListeners.values()) {
            listener.onDraw();
        }
    }
}

