/*
 * Decompiled with CFR 0.152.
 */
package aniways.com.google.tagmanager.protobuf.nano;

import aniways.com.google.tagmanager.protobuf.nano.MessageNano;
import java.lang.reflect.Array;
import java.lang.reflect.Field;

public final class MessageNanoPrinter {
    private static final String INDENT = "  ";
    private static final int MAX_STRING_LEN = 200;

    private MessageNanoPrinter() {
    }

    public static <T extends MessageNano> String print(T message) {
        if (message == null) {
            return "null";
        }
        StringBuffer buf = new StringBuffer();
        try {
            MessageNanoPrinter.print(message.getClass().getSimpleName(), message.getClass(), message, new StringBuffer(), buf);
        }
        catch (IllegalAccessException e) {
            return "Error printing proto: " + e.getMessage();
        }
        return buf.toString();
    }

    private static void print(String identifier, Class<?> clazz, Object message, StringBuffer indentBuf, StringBuffer buf) throws IllegalAccessException {
        if (MessageNano.class.isAssignableFrom(clazz)) {
            if (message == null) {
                return;
            }
            buf.append(indentBuf).append(identifier);
            indentBuf.append(INDENT);
            buf.append(" <\n");
            for (Field field : clazz.getFields()) {
                int modifiers = field.getModifiers();
                String fieldName = field.getName();
                if ((modifiers & 1) != 1 || (modifiers & 8) == 8 || fieldName.startsWith("_") || fieldName.endsWith("_")) continue;
                Class<?> fieldType = field.getType();
                Object value = field.get(message);
                if (fieldType.isArray()) {
                    Class<?> arrayType = fieldType.getComponentType();
                    if (arrayType == Byte.TYPE) {
                        MessageNanoPrinter.print(fieldName, fieldType, value, indentBuf, buf);
                        continue;
                    }
                    int len = value == null ? 0 : Array.getLength(value);
                    for (int i = 0; i < len; ++i) {
                        Object elem = Array.get(value, i);
                        MessageNanoPrinter.print(fieldName, arrayType, elem, indentBuf, buf);
                    }
                    continue;
                }
                MessageNanoPrinter.print(fieldName, fieldType, value, indentBuf, buf);
            }
            indentBuf.delete(indentBuf.length() - INDENT.length(), indentBuf.length());
            buf.append(indentBuf).append(">\n");
        } else {
            if (message == null) {
                return;
            }
            identifier = MessageNanoPrinter.deCamelCaseify(identifier);
            buf.append(indentBuf).append(identifier).append(": ");
            if (message instanceof String) {
                String stringMessage = MessageNanoPrinter.sanitizeString((String)message);
                buf.append("\"").append(stringMessage).append("\"");
            } else {
                buf.append(message);
            }
            buf.append("\n");
        }
    }

    private static String deCamelCaseify(String identifier) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < identifier.length(); ++i) {
            char currentChar = identifier.charAt(i);
            if (i == 0) {
                out.append(Character.toLowerCase(currentChar));
                continue;
            }
            if (Character.isUpperCase(currentChar)) {
                out.append('_').append(Character.toLowerCase(currentChar));
                continue;
            }
            out.append(currentChar);
        }
        return out.toString();
    }

    private static String sanitizeString(String str) {
        if (!str.startsWith("http") && str.length() > 200) {
            str = str.substring(0, 200) + "[...]";
        }
        return MessageNanoPrinter.escapeString(str);
    }

    private static String escapeString(String str) {
        int strLen = str.length();
        StringBuilder b = new StringBuilder(strLen);
        for (int i = 0; i < strLen; ++i) {
            char original = str.charAt(i);
            if (original >= ' ' && original <= '~' && original != '\"' && original != '\'') {
                b.append(original);
                continue;
            }
            b.append(String.format("\\u%04x", original));
        }
        return b.toString();
    }
}

