/*
 * Decompiled with CFR 0.152.
 */
package aniways.com.google.tagmanager;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import aniways.com.google.android.gms.common.util.VisibleForTesting;
import aniways.com.google.tagmanager.SharedPreferencesUtil;
import java.util.HashMap;
import java.util.Map;

class InstallReferrerUtil {
    static final String PREF_NAME_INSTALL_REFERRER = "gtm_install_referrer";
    static final String PREF_NAME_CLICK_REFERRERS = "gtm_click_referrers";
    static final String PREF_KEY_REFERRER = "referrer";
    static final String INTENT_EXTRA_REFERRER = "referrer";
    private static String installReferrer;
    @VisibleForTesting
    static Map<String, String> clickReferrers;

    InstallReferrerUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void cacheInstallReferrer(String referrer) {
        Class<InstallReferrerUtil> clazz = InstallReferrerUtil.class;
        synchronized (InstallReferrerUtil.class) {
            installReferrer = referrer;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static void saveInstallReferrer(Context context, String referrer) {
        SharedPreferencesUtil.saveAsync(context, PREF_NAME_INSTALL_REFERRER, "referrer", referrer);
        InstallReferrerUtil.addClickReferrer(context, referrer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String getInstallReferrer(Context context, String component) {
        if (installReferrer != null) return InstallReferrerUtil.extractComponent(installReferrer, component);
        Class<InstallReferrerUtil> clazz = InstallReferrerUtil.class;
        synchronized (InstallReferrerUtil.class) {
            if (installReferrer != null) return InstallReferrerUtil.extractComponent(installReferrer, component);
            SharedPreferences settings = context.getSharedPreferences(PREF_NAME_INSTALL_REFERRER, 0);
            installReferrer = settings != null ? settings.getString("referrer", "") : "";
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return InstallReferrerUtil.extractComponent(installReferrer, component);
        }
    }

    static void addClickReferrer(Context context, String referrer) {
        String conversionId = InstallReferrerUtil.extractComponent(referrer, "conv");
        if (conversionId != null && conversionId.length() > 0) {
            clickReferrers.put(conversionId, referrer);
            SharedPreferencesUtil.saveAsync(context, PREF_NAME_CLICK_REFERRERS, conversionId, referrer);
        }
    }

    static String extractComponent(String referrer, String component) {
        if (component == null) {
            return referrer.length() > 0 ? referrer : null;
        }
        Uri uri = Uri.parse((String)("http://hostname/?" + referrer));
        return uri.getQueryParameter(component);
    }

    static String getClickReferrer(Context context, String conversionId, String component) {
        String referrer = clickReferrers.get(conversionId);
        if (referrer == null) {
            SharedPreferences settings = context.getSharedPreferences(PREF_NAME_CLICK_REFERRERS, 0);
            referrer = settings != null ? settings.getString(conversionId, "") : "";
            clickReferrers.put(conversionId, referrer);
        }
        return InstallReferrerUtil.extractComponent(referrer, component);
    }

    static {
        clickReferrers = new HashMap<String, String>();
    }
}

