/*
 * Decompiled with CFR 0.152.
 */
package aniways.com.google.tagmanager;

import aniways.com.google.android.gms.common.util.VisibleForTesting;
import aniways.com.google.tagmanager.Log;
import aniways.com.google.tagmanager.NetworkClient;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

class HttpNetworkClient
implements NetworkClient {
    private HttpClient mClient;

    HttpNetworkClient() {
    }

    @Override
    public InputStream getInputStream(String url) throws IOException {
        this.mClient = this.createNewHttpClient();
        HttpResponse response = this.mClient.execute((HttpUriRequest)new HttpGet(url));
        return this.handleServerResponse(this.mClient, response);
    }

    @Override
    public void sendPostRequest(String url, byte[] content) throws IOException {
        HttpClient client = this.createNewHttpClient();
        HttpPost httpPost = this.createPostRequest(url, content);
        HttpResponse response = client.execute((HttpUriRequest)httpPost);
        this.handleServerResponse(client, response);
        this.closeWithClient(client);
    }

    @VisibleForTesting
    HttpPost createPostRequest(String url, byte[] content) {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity((HttpEntity)new ByteArrayEntity(content));
        return httpPost;
    }

    @Override
    public void close() {
        this.closeWithClient(this.mClient);
    }

    private void closeWithClient(HttpClient client) {
        if (client != null && client.getConnectionManager() != null) {
            client.getConnectionManager().shutdown();
        }
    }

    private InputStream handleServerResponse(HttpClient client, HttpResponse response) throws IOException {
        int responseCode = response.getStatusLine().getStatusCode();
        if (responseCode == 200) {
            Log.v("Success response");
            return response.getEntity().getContent();
        }
        String errorMessage = "Bad response: " + responseCode;
        if (responseCode == 404) {
            throw new FileNotFoundException(errorMessage);
        }
        throw new IOException(errorMessage);
    }

    @VisibleForTesting
    HttpClient createNewHttpClient() {
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)20000);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)20000);
        return new DefaultHttpClient((HttpParams)params);
    }
}

