/*
 * Decompiled with CFR 0.152.
 */
package aniways.com.google.tagmanager;

import aniways.com.google.analytics.containertag.proto.Debug;
import aniways.com.google.analytics.midtier.proto.containertag.TypeSystem;
import aniways.com.google.tagmanager.ArrayUtils;
import aniways.com.google.tagmanager.DebugResolvedFunctionCallBuilder;
import aniways.com.google.tagmanager.DebugValueBuilder;
import aniways.com.google.tagmanager.Log;
import aniways.com.google.tagmanager.ResolvedFunctionCallBuilder;
import aniways.com.google.tagmanager.ResolvedFunctionCallTranslatorList;
import aniways.com.google.tagmanager.ResolvedRuleBuilder;
import aniways.com.google.tagmanager.ResourceUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class DebugResolvedRuleBuilder
implements ResolvedRuleBuilder {
    Debug.ResolvedRule resolvedRule;
    ResolvedFunctionCallTranslatorList addMacrosHolder;
    ResolvedFunctionCallTranslatorList removeMacrosHolder;
    ResolvedFunctionCallTranslatorList addTagsHolder;
    ResolvedFunctionCallTranslatorList removeTagsHolder;

    public DebugResolvedRuleBuilder(Debug.ResolvedRule rule) {
        this.resolvedRule = rule;
        this.addMacrosHolder = new DebugResolvedFunctionCallListTranslator(1);
        this.removeMacrosHolder = new DebugResolvedFunctionCallListTranslator(2);
        this.addTagsHolder = new DebugResolvedFunctionCallListTranslator(3);
        this.removeTagsHolder = new DebugResolvedFunctionCallListTranslator(4);
    }

    @Override
    public ResolvedFunctionCallBuilder createNegativePredicate() {
        Debug.ResolvedFunctionCall predicate = new Debug.ResolvedFunctionCall();
        this.resolvedRule.negativePredicates = ArrayUtils.appendToArray(this.resolvedRule.negativePredicates, predicate);
        return new DebugResolvedFunctionCallBuilder(predicate);
    }

    @Override
    public ResolvedFunctionCallBuilder createPositivePredicate() {
        Debug.ResolvedFunctionCall predicate = new Debug.ResolvedFunctionCall();
        this.resolvedRule.positivePredicates = ArrayUtils.appendToArray(this.resolvedRule.positivePredicates, predicate);
        return new DebugResolvedFunctionCallBuilder(predicate);
    }

    @Override
    public ResolvedFunctionCallTranslatorList getAddedMacroFunctions() {
        return this.addMacrosHolder;
    }

    @Override
    public ResolvedFunctionCallTranslatorList getRemovedMacroFunctions() {
        return this.removeMacrosHolder;
    }

    @Override
    public ResolvedFunctionCallTranslatorList getAddedTagFunctions() {
        return this.addTagsHolder;
    }

    @Override
    public ResolvedFunctionCallTranslatorList getRemovedTagFunctions() {
        return this.removeTagsHolder;
    }

    @Override
    public void setValue(TypeSystem.Value result) {
        this.resolvedRule.result = DebugValueBuilder.copyImmutableValue(result);
    }

    public static Debug.ResolvedFunctionCall translateExpandedFunctionCall(ResourceUtil.ExpandedFunctionCall f) {
        Debug.ResolvedFunctionCall result = new Debug.ResolvedFunctionCall();
        for (Map.Entry<String, TypeSystem.Value> originalParam : f.getProperties().entrySet()) {
            Debug.ResolvedProperty prop = new Debug.ResolvedProperty();
            prop.key = originalParam.getKey();
            prop.value = DebugValueBuilder.copyImmutableValue(originalParam.getValue());
            result.properties = ArrayUtils.appendToArray(result.properties, prop);
        }
        return result;
    }

    class DebugResolvedFunctionCallListTranslator
    implements ResolvedFunctionCallTranslatorList {
        private final int type;

        DebugResolvedFunctionCallListTranslator(int type) {
            this.type = type;
        }

        @Override
        public void translateAndAddAll(List<ResourceUtil.ExpandedFunctionCall> functions, List<String> ruleNames) {
            ArrayList<Debug.ResolvedFunctionCall> translatedList = new ArrayList<Debug.ResolvedFunctionCall>(functions.size());
            for (int i = 0; i < functions.size(); ++i) {
                translatedList.add(DebugResolvedRuleBuilder.translateExpandedFunctionCall(functions.get(i)));
                ((Debug.ResolvedFunctionCall)translatedList.get((int)i)).associatedRuleName = i < ruleNames.size() ? ruleNames.get(i) : "Unknown";
            }
            Debug.ResolvedFunctionCall[] translated = translatedList.toArray(new Debug.ResolvedFunctionCall[0]);
            switch (this.type) {
                case 1: {
                    DebugResolvedRuleBuilder.this.resolvedRule.addMacros = translated;
                    break;
                }
                case 2: {
                    DebugResolvedRuleBuilder.this.resolvedRule.removeMacros = translated;
                    break;
                }
                case 3: {
                    DebugResolvedRuleBuilder.this.resolvedRule.addTags = translated;
                    break;
                }
                case 4: {
                    DebugResolvedRuleBuilder.this.resolvedRule.removeTags = translated;
                    break;
                }
                default: {
                    Log.e("unknown type in translateAndAddAll: " + this.type);
                }
            }
        }

        class Type {
            static final int ADD_MACROS = 1;
            static final int REMOVE_MACROS = 2;
            static final int ADD_TAGS = 3;
            static final int REMOVE_TAGS = 4;

            Type() {
            }
        }
    }
}

