/*
 * Decompiled with CFR 0.152.
 */
package aniways.com.google.tagmanager;

import aniways.com.google.analytics.containertag.common.FunctionType;
import aniways.com.google.analytics.containertag.common.Key;
import aniways.com.google.analytics.midtier.proto.containertag.TypeSystem;
import aniways.com.google.tagmanager.DataLayer;
import aniways.com.google.tagmanager.FunctionCallImplementation;
import aniways.com.google.tagmanager.Types;
import java.util.Map;

class DataLayerMacro
extends FunctionCallImplementation {
    private static final String ID = FunctionType.CUSTOM_VAR.toString();
    private static final String NAME = Key.NAME.toString();
    private static final String DEFAULT_VALUE = Key.DEFAULT_VALUE.toString();
    private final DataLayer mDataLayer;

    public static String getFunctionId() {
        return ID;
    }

    public DataLayerMacro(DataLayer dataLayer) {
        super(ID, NAME);
        this.mDataLayer = dataLayer;
    }

    public static String getNameKey() {
        return NAME;
    }

    public static String getDefaultValueKey() {
        return DEFAULT_VALUE;
    }

    @Override
    public boolean isCacheable() {
        return false;
    }

    @Override
    public TypeSystem.Value evaluate(Map<String, TypeSystem.Value> parameters) {
        Object dataLayerValue = this.mDataLayer.get(Types.valueToString(parameters.get(NAME)));
        if (dataLayerValue == null) {
            TypeSystem.Value defaultValue = parameters.get(DEFAULT_VALUE);
            if (defaultValue != null) {
                return defaultValue;
            }
            return Types.getDefaultValue();
        }
        return Types.objectToValue(dataLayerValue);
    }
}

