/*
 * Decompiled with CFR 0.152.
 */
package aniways.com.google.tagmanager;

import android.os.Build;
import aniways.com.google.android.gms.common.util.VisibleForTesting;
import aniways.com.google.tagmanager.Cache;
import aniways.com.google.tagmanager.LRUCache;
import aniways.com.google.tagmanager.SimpleCache;

class CacheFactory<K, V> {
    @VisibleForTesting
    final CacheSizeManager<K, V> mDefaultSizeManager = new CacheSizeManager<K, V>(){

        @Override
        public int sizeOf(K key, V value) {
            return 1;
        }
    };

    public Cache<K, V> createCache(int maxSize) {
        return this.createCache(maxSize, this.mDefaultSizeManager);
    }

    public Cache<K, V> createCache(int maxSize, CacheSizeManager<K, V> sizeManager) {
        if (maxSize <= 0) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        if (this.getSdkVersion() < 12) {
            return new SimpleCache<K, V>(maxSize, sizeManager);
        }
        return new LRUCache<K, V>(maxSize, sizeManager);
    }

    @VisibleForTesting
    int getSdkVersion() {
        return Build.VERSION.SDK_INT;
    }

    public static interface CacheSizeManager<K, V> {
        public int sizeOf(K var1, V var2);
    }
}

