/*
 * Decompiled with CFR 0.152.
 */
package aniways.com.google.tagmanager;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import aniways.com.google.analytics.containertag.common.FunctionType;
import aniways.com.google.analytics.containertag.common.Key;
import aniways.com.google.analytics.midtier.proto.containertag.TypeSystem;
import aniways.com.google.android.gms.common.util.VisibleForTesting;
import aniways.com.google.tagmanager.DelayedHitSender;
import aniways.com.google.tagmanager.HitSender;
import aniways.com.google.tagmanager.Log;
import aniways.com.google.tagmanager.SharedPreferencesUtil;
import aniways.com.google.tagmanager.TrackingTag;
import aniways.com.google.tagmanager.Types;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ArbitraryPixelTag
extends TrackingTag {
    private static final String ID = FunctionType.ARBITRARY_PIXEL.toString();
    private static final String URL = Key.URL.toString();
    private static final String ADDITIONAL_PARAMS = Key.ADDITIONAL_PARAMS.toString();
    private static final String UNREPEATABLE = Key.UNREPEATABLE.toString();
    static final String ARBITRARY_PIXEL_UNREPEATABLE = "gtm_" + ID + "_unrepeatable";
    private static final Set<String> unrepeatableIds = new HashSet<String>();
    private final HitSenderProvider mHitSenderProvider;
    private final Context mContext;

    public static String getFunctionId() {
        return ID;
    }

    public ArbitraryPixelTag(final Context context) {
        this(context, new HitSenderProvider(){

            @Override
            public HitSender get() {
                return DelayedHitSender.getInstance(context);
            }
        });
    }

    @VisibleForTesting
    ArbitraryPixelTag(Context context, HitSenderProvider hitSenderProvider) {
        super(ID, URL);
        this.mHitSenderProvider = hitSenderProvider;
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void evaluateTrackingTag(Map<String, TypeSystem.Value> tag) {
        String unrepeatableId;
        String string = unrepeatableId = tag.get(UNREPEATABLE) != null ? Types.valueToString(tag.get(UNREPEATABLE)) : null;
        if (unrepeatableId != null && this.idProcessed(unrepeatableId)) {
            return;
        }
        String url = Types.valueToString(tag.get(URL));
        Uri initialUri = Uri.parse((String)url);
        Uri.Builder uriBuilder = initialUri.buildUpon();
        TypeSystem.Value additionalParamsList = tag.get(ADDITIONAL_PARAMS);
        if (additionalParamsList != null) {
            Object l = Types.valueToObject(additionalParamsList);
            if (!(l instanceof List)) {
                Log.e("ArbitraryPixel: additional params not a list: not sending partial hit: " + uriBuilder.build().toString());
                return;
            }
            List list = (List)l;
            for (Object m : list) {
                if (!(m instanceof Map)) {
                    Log.e("ArbitraryPixel: additional params contains non-map: not sending partial hit: " + uriBuilder.build().toString());
                    return;
                }
                Map map = (Map)m;
                for (Map.Entry entry : map.entrySet()) {
                    uriBuilder.appendQueryParameter(entry.getKey().toString(), entry.getValue().toString());
                }
            }
        }
        String uri = uriBuilder.build().toString();
        this.mHitSenderProvider.get().sendHit(uri);
        Log.v("ArbitraryPixel: url = " + uri);
        if (unrepeatableId == null) return;
        Class<ArbitraryPixelTag> clazz = ArbitraryPixelTag.class;
        synchronized (ArbitraryPixelTag.class) {
            unrepeatableIds.add(unrepeatableId);
            SharedPreferencesUtil.saveAsync(this.mContext, ARBITRARY_PIXEL_UNREPEATABLE, unrepeatableId, "true");
            // ** MonitorExit[var8_8] (shouldn't be in output)
            return;
        }
    }

    private synchronized boolean idProcessed(String unrepeatableId) {
        if (this.idInCache(unrepeatableId)) {
            return true;
        }
        if (this.idInSharedPreferences(unrepeatableId)) {
            unrepeatableIds.add(unrepeatableId);
            return true;
        }
        return false;
    }

    @VisibleForTesting
    boolean idInSharedPreferences(String unrepeatableId) {
        SharedPreferences settings = this.mContext.getSharedPreferences(ARBITRARY_PIXEL_UNREPEATABLE, 0);
        return settings.contains(unrepeatableId);
    }

    @VisibleForTesting
    void clearCache() {
        unrepeatableIds.clear();
    }

    @VisibleForTesting
    boolean idInCache(String unrepeatableId) {
        return unrepeatableIds.contains(unrepeatableId);
    }

    public static interface HitSenderProvider {
        public HitSender get();
    }
}

