/*
 * Decompiled with CFR 0.152.
 */
package aniways.com.google.analytics.tracking.android;

import android.text.TextUtils;
import aniways.com.google.analytics.tracking.android.Hit;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

class HitBuilder {
    HitBuilder() {
    }

    static Map<String, String> generateHitParams(Map<String, String> hit) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : hit.entrySet()) {
            String urlParam;
            if (!entry.getKey().startsWith("&") || entry.getValue() == null || TextUtils.isEmpty((CharSequence)(urlParam = entry.getKey().substring(1)))) continue;
            params.put(urlParam, entry.getValue());
        }
        return params;
    }

    static String postProcessHit(Hit hit, long currentTimeMillis) {
        long queueTime;
        StringBuilder builder = new StringBuilder();
        builder.append(hit.getHitParams());
        if (hit.getHitTime() > 0L && (queueTime = currentTimeMillis - hit.getHitTime()) >= 0L) {
            builder.append("&qt").append("=").append(queueTime);
        }
        builder.append("&z").append("=").append(hit.getHitId());
        return builder.toString();
    }

    static String encode(String input) {
        try {
            return URLEncoder.encode(input, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)("URL encoding failed for: " + input));
        }
    }
}

