/*
 * Decompiled with CFR 0.152.
 */
package aniways.com.google.analytics.tracking.android;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import aniways.com.google.analytics.tracking.android.AnalyticsStore;
import aniways.com.google.analytics.tracking.android.AnalyticsStoreStateListener;
import aniways.com.google.analytics.tracking.android.AnalyticsThread;
import aniways.com.google.analytics.tracking.android.GANetworkReceiver;
import aniways.com.google.analytics.tracking.android.GAUsage;
import aniways.com.google.analytics.tracking.android.Log;
import aniways.com.google.analytics.tracking.android.PersistentAnalyticsStore;
import aniways.com.google.analytics.tracking.android.ServiceManager;
import aniways.com.google.android.gms.common.util.VisibleForTesting;

public class GAServiceManager
extends ServiceManager {
    private static final int MSG_KEY = 1;
    private static final Object MSG_OBJECT = new Object();
    private Context ctx;
    private AnalyticsStore store;
    private volatile AnalyticsThread thread;
    private int dispatchPeriodInSeconds = 1800;
    private boolean pendingDispatch = true;
    private boolean pendingForceLocalDispatch;
    private String pendingHostOverride;
    private boolean connected = true;
    private boolean listenForNetwork = true;
    private AnalyticsStoreStateListener listener = new AnalyticsStoreStateListener(){

        @Override
        public void reportStoreIsEmpty(boolean isEmpty) {
            GAServiceManager.this.updatePowerSaveMode(isEmpty, GAServiceManager.this.connected);
        }
    };
    private Handler handler;
    private GANetworkReceiver networkReceiver;
    private boolean storeIsEmpty = false;
    private static GAServiceManager instance;

    public static GAServiceManager getInstance() {
        if (instance == null) {
            instance = new GAServiceManager();
        }
        return instance;
    }

    private GAServiceManager() {
    }

    @VisibleForTesting
    static void clearInstance() {
        instance = null;
    }

    @VisibleForTesting
    GAServiceManager(Context ctx, AnalyticsThread thread, AnalyticsStore store, boolean listenForNetwork) {
        this.store = store;
        this.thread = thread;
        this.listenForNetwork = listenForNetwork;
        this.initialize(ctx, thread);
    }

    private void initializeNetworkReceiver() {
        this.networkReceiver = new GANetworkReceiver(this);
        this.networkReceiver.register(this.ctx);
    }

    private void initializeHandler() {
        this.handler = new Handler(this.ctx.getMainLooper(), new Handler.Callback(){

            public boolean handleMessage(Message msg) {
                if (1 == msg.what && MSG_OBJECT.equals(msg.obj)) {
                    GAUsage.getInstance().setDisableUsage(true);
                    GAServiceManager.this.dispatchLocalHits();
                    GAUsage.getInstance().setDisableUsage(false);
                    if (GAServiceManager.this.dispatchPeriodInSeconds > 0 && !GAServiceManager.this.storeIsEmpty) {
                        GAServiceManager.this.handler.sendMessageDelayed(GAServiceManager.this.handler.obtainMessage(1, MSG_OBJECT), (long)(GAServiceManager.this.dispatchPeriodInSeconds * 1000));
                    }
                }
                return true;
            }
        });
        if (this.dispatchPeriodInSeconds > 0) {
            this.handler.sendMessageDelayed(this.handler.obtainMessage(1, MSG_OBJECT), (long)(this.dispatchPeriodInSeconds * 1000));
        }
    }

    synchronized void initialize(Context ctx, AnalyticsThread thread) {
        if (this.ctx != null) {
            return;
        }
        this.ctx = ctx.getApplicationContext();
        if (this.thread == null) {
            this.thread = thread;
            if (this.pendingDispatch) {
                this.dispatchLocalHits();
                this.pendingDispatch = false;
            }
            if (this.pendingForceLocalDispatch) {
                this.setForceLocalDispatch();
                this.pendingForceLocalDispatch = false;
            }
        }
    }

    @VisibleForTesting
    AnalyticsStoreStateListener getListener() {
        return this.listener;
    }

    synchronized AnalyticsStore getStore() {
        if (this.store == null) {
            if (this.ctx == null) {
                throw new IllegalStateException("Cant get a store unless we have a context");
            }
            this.store = new PersistentAnalyticsStore(this.listener, this.ctx);
            if (this.pendingHostOverride != null) {
                this.store.getDispatcher().overrideHostUrl(this.pendingHostOverride);
                this.pendingHostOverride = null;
            }
        }
        if (this.handler == null) {
            this.initializeHandler();
        }
        if (this.networkReceiver == null && this.listenForNetwork) {
            this.initializeNetworkReceiver();
        }
        return this.store;
    }

    @VisibleForTesting
    synchronized void overrideHostUrl(String hostOverride) {
        if (this.store == null) {
            this.pendingHostOverride = hostOverride;
        } else {
            this.store.getDispatcher().overrideHostUrl(hostOverride);
        }
    }

    @Override
    @Deprecated
    public synchronized void dispatchLocalHits() {
        if (this.thread == null) {
            Log.v("Dispatch call queued. Dispatch will run once initialization is complete.");
            this.pendingDispatch = true;
            return;
        }
        GAUsage.getInstance().setUsage(GAUsage.Field.DISPATCH);
        this.thread.dispatch();
    }

    @Override
    @Deprecated
    public synchronized void setLocalDispatchPeriod(int dispatchPeriodInSeconds) {
        if (this.handler == null) {
            Log.v("Dispatch period set with null handler. Dispatch will run once initialization is complete.");
            this.dispatchPeriodInSeconds = dispatchPeriodInSeconds;
            return;
        }
        GAUsage.getInstance().setUsage(GAUsage.Field.SET_DISPATCH_PERIOD);
        if (!this.storeIsEmpty && this.connected && this.dispatchPeriodInSeconds > 0) {
            this.handler.removeMessages(1, MSG_OBJECT);
        }
        this.dispatchPeriodInSeconds = dispatchPeriodInSeconds;
        if (dispatchPeriodInSeconds > 0 && !this.storeIsEmpty && this.connected) {
            this.handler.sendMessageDelayed(this.handler.obtainMessage(1, MSG_OBJECT), (long)(dispatchPeriodInSeconds * 1000));
        }
    }

    @Override
    @Deprecated
    public void setForceLocalDispatch() {
        if (this.thread == null) {
            Log.v("setForceLocalDispatch() queued. It will be called once initialization is complete.");
            this.pendingForceLocalDispatch = true;
            return;
        }
        GAUsage.getInstance().setUsage(GAUsage.Field.SET_FORCE_LOCAL_DISPATCH);
        this.thread.setForceLocalDispatch();
    }

    @VisibleForTesting
    synchronized void updatePowerSaveMode(boolean storeIsEmpty, boolean connected) {
        if (this.storeIsEmpty == storeIsEmpty && this.connected == connected) {
            return;
        }
        if ((storeIsEmpty || !connected) && this.dispatchPeriodInSeconds > 0) {
            this.handler.removeMessages(1, MSG_OBJECT);
        }
        if (!storeIsEmpty && connected && this.dispatchPeriodInSeconds > 0) {
            this.handler.sendMessageDelayed(this.handler.obtainMessage(1, MSG_OBJECT), (long)(this.dispatchPeriodInSeconds * 1000));
        }
        Log.v("PowerSaveMode " + (storeIsEmpty || !connected ? "initiated." : "terminated."));
        this.storeIsEmpty = storeIsEmpty;
        this.connected = connected;
    }

    @Override
    synchronized void updateConnectivityStatus(boolean connected) {
        this.updatePowerSaveMode(this.storeIsEmpty, connected);
    }

    @Override
    synchronized void onRadioPowered() {
        if (!this.storeIsEmpty && this.connected && this.dispatchPeriodInSeconds > 0) {
            this.handler.removeMessages(1, MSG_OBJECT);
            this.handler.sendMessage(this.handler.obtainMessage(1, MSG_OBJECT));
        }
    }
}

