/*
 * Decompiled with CFR 0.152.
 */
package aniways.com.google.analytics.tracking.android;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import aniways.com.google.analytics.tracking.android.DefaultProvider;
import aniways.com.google.analytics.tracking.android.Log;
import aniways.com.google.android.gms.common.util.VisibleForTesting;

class AppFieldsDefaultProvider
implements DefaultProvider {
    protected String mAppName;
    protected String mAppVersion;
    protected String mAppId;
    protected String mAppInstallerId;
    private static AppFieldsDefaultProvider sInstance;
    private static Object sInstanceLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeProvider(Context c) {
        Object object = sInstanceLock;
        synchronized (object) {
            if (sInstance == null) {
                sInstance = new AppFieldsDefaultProvider(c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static void dropInstance() {
        Object object = sInstanceLock;
        synchronized (object) {
            sInstance = null;
        }
    }

    public static AppFieldsDefaultProvider getProvider() {
        return sInstance;
    }

    private AppFieldsDefaultProvider(Context c) {
        PackageManager pm = c.getPackageManager();
        this.mAppId = c.getPackageName();
        this.mAppInstallerId = pm.getInstallerPackageName(this.mAppId);
        String appName = this.mAppId;
        String appVersion = null;
        try {
            PackageInfo packageInfo = pm.getPackageInfo(c.getPackageName(), 0);
            if (packageInfo != null) {
                appName = pm.getApplicationLabel(packageInfo.applicationInfo).toString();
                appVersion = packageInfo.versionName;
            }
        }
        catch (PackageManager.NameNotFoundException exception) {
            Log.e("Error retrieving package info: appName set to " + appName);
        }
        this.mAppName = appName;
        this.mAppVersion = appVersion;
    }

    @VisibleForTesting
    protected AppFieldsDefaultProvider() {
    }

    @Override
    public boolean providesField(String field) {
        return "&an".equals(field) || "&av".equals(field) || "&aid".equals(field) || "&aiid".equals(field);
    }

    @Override
    public String getValue(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals("&an")) {
            return this.mAppName;
        }
        if (field.equals("&av")) {
            return this.mAppVersion;
        }
        if (field.equals("&aid")) {
            return this.mAppId;
        }
        if (field.equals("&aiid")) {
            return this.mAppInstallerId;
        }
        return null;
    }

    static {
        sInstanceLock = new Object();
    }
}

