/**
 * 
 */
package com.aniways.service.task;

import java.util.concurrent.atomic.AtomicInteger;

/**
 * @author Shai
 *
 */
public class FileDownloadCounter{
	private AtomicInteger mDownloadCounter;
	private AtomicInteger mByteCounter;
	
	public FileDownloadCounter(){
		mDownloadCounter = new AtomicInteger();
		mByteCounter = new AtomicInteger();
	}
	
	public int incrementDownloadCount(){
		return mDownloadCounter.getAndIncrement();
	}
	
	public int getDownloadCount(){
		return mDownloadCounter.get();
	}
	
	public int incrementByteCount(int amount){
		return mByteCounter.addAndGet(amount);
	}
	
	public int getKbCount(){
		return mByteCounter.get()/1024;
	}
}
