package com.aniways.service.manager;

import android.content.Context;
import com.aniways.Log;

import com.aniways.service.AniwaysAlarmListener;
import com.aniways.service.WakefulIntentService;

/**
 * UpdateManager is used to manage the update service of aniways,
 * with this class the user could start the service and stop.
 */
public class UpdateManager {

	private static final String TAG = "AniwaysUpdateManager";

	/**
	 * Starts the update service.
	 * @param context Application context.
	 */
	public static void startUpdates(Context context) {
		try{
			Log.i(TAG, "Start updates called");

			WakefulIntentService.scheduleAlarms(new AniwaysAlarmListener(), context);
		}
		catch(Throwable ex){
			Log.e(true, TAG, "Caught Exception in startUpdates", ex);
		}

		// TODO: this is currently disabled since it is not in a different process..
		// Start the service - the service will schedule alarms to wake it up..
		//WakefulIntentService.sendWakefulWork(context, AniwaysIntentService.class);
	}

	///**
	// * Stop the update service, if the service already running it will only be stopped
	// * after it will finish the execution of the work he need to do.
	// * @param context Application context.
	// */
	//public static void stopUpdates(Context context) {
	//	Log.i(TAG, "Stop updates called");
	//	WakefulIntentService.cancelAlarms(context);
	//}
}
