package com.aniways.service;

import com.aniways.Log;
import com.aniways.analytics.AnalyticsReporter;
import com.aniways.analytics.GoogleAnalyticsReporter;
import com.aniways.data.AniwaysPhraseReplacementData;
import com.aniways.data.AniwaysConfiguration.Verbosity;
import com.aniways.service.utils.AniwaysServiceUtils;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.os.SystemClock;

/**
 * Implements the AlarmListener interface, with values adjusted to the AniwaysIntentService.
 */
public class AniwaysAlarmListener implements AlarmListener {
	private static final String TAG = "AniwaysAlarmListener";

	/**
	 * Schedule the updates.
	 */
	@Override
	public void scheduleAlarms(AlarmManager alarmManager, PendingIntent pendingIntent, long interval, long timeOfFirstAlarmFromNow, Context context, String alarmName) {
		try{
			Log.i(TAG, "Scheduling alarms to wake the process and perform " + alarmName + ". Interval: " + interval + ". Time of first alarm from now: " + timeOfFirstAlarmFromNow);
			// Schedule the alarms every pre-defined interval.
			
			// First, cancel any intents that are waiting.. 
			alarmManager.cancel(pendingIntent);
			
			alarmManager.setRepeating(AlarmManager.ELAPSED_REALTIME_WAKEUP,
					SystemClock.elapsedRealtime() + 
					timeOfFirstAlarmFromNow,
					interval, pendingIntent);
		}
		catch(Throwable ex){
			Log.e(true, TAG, "Caught Exception in scheduleAlrams", ex);
		}
	}

	/**
	 * Execute the updates.
	 */
	@Override
	public void sendWakefulWork(Context context, boolean fromAlarm) {
		try{
			if(AniwaysServiceUtils.shouldPerformSync(context)) {
				long now = System.currentTimeMillis();
				long lastSuccessfulUpdate = AniwaysServiceUtils.getLastSuccessfulUpdate(context);
				if(lastSuccessfulUpdate < 1){
					lastSuccessfulUpdate = now;
				}
				if(!AniwaysPhraseReplacementData.isInit()){
					Log.i(TAG, "Requesting to perform sync with the Aniways Backend Server because alarm was fired while process was down");
					GoogleAnalyticsReporter.reportEvent(Verbosity.Info, "Statistics", "Request backend sync" + (fromAlarm ? "-from alarm" : "") + (lastSuccessfulUpdate == now ? "-first time" : ""), "unknown", (now - lastSuccessfulUpdate) / (1000*60*60));
				}
				else{
					boolean keywordsVersionIsZero = AniwaysPhraseReplacementData.getDataParser().getKeywordsVersion().equalsIgnoreCase(AniwaysPhraseReplacementData.EMPTY_PARSER_VERSION);
					Log.i(TAG, "Requesting to perform sync with the Aniways Backend Server because " + (keywordsVersionIsZero ? "keywords version is " + AniwaysPhraseReplacementData.EMPTY_PARSER_VERSION : "its been too long since the last successful sync") + " and the service is not currently running");
					GoogleAnalyticsReporter.reportEvent(Verbosity.Info, "Statistics", "Request backend sync" + (fromAlarm ? "-from alarm" : "") + (lastSuccessfulUpdate == now ? "-first time" : ""), AniwaysPhraseReplacementData.getDataParser().getKeywordsVersion(), (now - lastSuccessfulUpdate) / (1000*60*60));
				}
				AnalyticsReporter.reportRequestBackendSync(now - lastSuccessfulUpdate, fromAlarm);
				WakefulIntentService.sendWakefulWork(context, AniwaysIntentService.class, fromAlarm);
			}
			else{
				Log.v(TAG, "Not performing sync. Following alarm: " + fromAlarm);
			}
		}
		catch(Throwable ex){
			Log.e(true, TAG, "Caught Exception in sendWakefulWork", ex);
		}
	}
}
