package com.aniways.data;

public class PhrasesHashSet extends CustomHashSet<Phrase> {
    
	public PhrasesHashSet(int capacity) {
		super(capacity);
		// TODO Auto-generated constructor stub
	}

	@Override
	protected void generateKeys(int capacity){
		keys = new Phrase[capacity];
	}
	
    public Phrase get(String key) {
        if (key == null) throw new IllegalArgumentException("key cannot be " + NULL);
        int index = indexFor(key);
        
        Phrase candidate = keys[index];
        
        while (candidate != NULL) {
        	
        	if (candidate.equals(key)) {
                return candidate;
            }
            index = successor(index);
            candidate = keys[index];
        }

        return NULL;
    }
    
    private int indexFor(String key) {
        return Math.abs((key.hashCode() % keys.length));
    }
}