/**
 * 
 */
package com.aniways.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;

import android.annotation.SuppressLint;
import aniways.com.google.gson.Gson;

/**
 * @author Shai
 *
 */
public class KeywordsFile {
    public String version;

    public HashMap<String, HashMap<String, String[]>> phraseToAnimatedGifs;

    public HashMap<String, HashMap<String, Long[]>> phrasesToIcons;

    public long[] lockedIcons;

    public HashMap<String, ArrayList<Long>> iconFamilies;

    public LinkedHashMap<String, LinkedHashMap<String, Long[]>> superCategoriesToIconFamilies;

    public HashMap<Long, String> primaryPhrases;

    public LinkedHashMap<String, String> superCategoriesToIcons;
    
    public HashMap<Long, String> iconsToExternalApps;
    
    public HashMap<Long, String> iconsToExternalWebsite;
    
    public HashSet<Long> animatedGifs;

    public HashMap<String, Long> phrasesToCommercialIcons;

    public long emojiMinIndex;
    public long emojiMaxIndex;
    public int iconsCount;
    public int commercialIconsCount;
    public int numOfCommercialPhrases;
    public int numberOfEmojis;
    public int numPhrases;
	public int numPhraseChars;
    public HashMap<Long, String> iconIdsToEmojiUnicodes;
    
    @SuppressLint("UseSparseArrays") public KeywordsFile(){
		this.version = AniwaysPhraseReplacementData.EMPTY_PARSER_VERSION;
		phrasesToIcons = new HashMap<String, HashMap<String, Long[]>>();
        phraseToAnimatedGifs = new HashMap<String,HashMap<String,String[]>>();
		lockedIcons = new long[0];
		iconFamilies = new HashMap<String, ArrayList<Long>>();
	    superCategoriesToIconFamilies = new LinkedHashMap<String, LinkedHashMap<String, Long[]>>();
	    primaryPhrases = new HashMap<Long, String>();
	    superCategoriesToIcons = new LinkedHashMap<String, String>();
	    iconsCount = -1;
	    emojiMinIndex = 1000;
	    emojiMaxIndex = 2999;
	    numberOfEmojis = 845;
	    numPhrases = -1;
		numPhraseChars = -1;
        commercialIconsCount = -1;
        numOfCommercialPhrases = -1;
	    animatedGifs = new HashSet<Long>();
	    iconIdsToEmojiUnicodes = new HashMap<Long, String>();
	    iconsToExternalApps = new HashMap<Long, String>();
	    iconsToExternalWebsite = new HashMap<Long, String>();
        phrasesToCommercialIcons = new HashMap<String, Long>();
        phraseToAnimatedGifs = new HashMap<>();
	}

	static KeywordsFile parseFromJson(String jsontext) {
		Gson gson = new Gson();  
		return gson.fromJson(jsontext, KeywordsFile.class);
	}
}
