package com.aniways.data;

import com.aniways.IconData;

public class IconsHashSet extends CustomHashSet<IconData> {

	public IconsHashSet(int capacity) {
		super(capacity);
	}

	@Override
	protected void generateKeys(int capacity){
		keys = new IconData[capacity];
	}

    public IconData get(int key) {

        int index = indexFor(key);
        
        IconData candidate = keys[index]; 
        while (candidate != NULL) {
            if (candidate.id == key) {
                return candidate;
            }
            index = successor(index);
            candidate = keys[index]; 
        }

        return NULL;
    }
    
    private int indexFor(int key) {
        return Math.abs((key % keys.length));
    }
}