package com.aniways.data;

import com.aniways.AssetType;
import com.aniways.IAniwaysImageSpan;
import com.aniways.IconData;
import com.aniways.IconDataForInteractive;

public class IconDataFactory {
	public static IconData iconData(Long id, String familyName, KeywordsFile keywordsFile, boolean isEmoji) {

        //TODO: get asset type and provider from above
		String externalApp = keywordsFile.iconsToExternalApps.get(id);
		String externalWebsite = keywordsFile.iconsToExternalWebsite.get(id);
		boolean animated = keywordsFile.animatedGifs.contains(id);
		int intId = id.intValue();
		if(externalApp != null || externalWebsite != null){
			return new IconDataForInteractive(intId, familyName, false, null, isEmoji, keywordsFile.iconIdsToEmojiUnicodes.get(id), externalApp, externalWebsite, animated);
		}
        //TODO: the provider will not always be Aniways..
		return new IconData(intId, familyName, false, null, keywordsFile.iconIdsToEmojiUnicodes.get(id), (isEmoji? AssetType.Emoji : AssetType.Emoticons), IAniwaysImageSpan.AssetProvider.Aniways, animated);
	}
}
