package com.aniways.data;

import com.aniways.service.utils.AniwaysAction;

import java.util.HashMap;
import java.util.List;

public abstract class DataForAssetTypeInPhrase {
    protected static final HashMap<Integer,DataForPhraseRequestContext> requests = new HashMap<>();
    private static int lastRequestId = 0;
    protected AniwaysAction<List<IAniwaysAssetInfo>> getBuildersCallback(final int requestId, final DataForPhraseRequestContext ctx) {
        return new AniwaysAction<List<IAniwaysAssetInfo>>() {

            @Override
            public synchronized void call(List<IAniwaysAssetInfo> assetInfos) {
                ctx.numCallbacksFromBuilders++;

                if (assetInfos != null && !assetInfos.isEmpty()) {
                    ctx.assetInfos.addAll(assetInfos);
                }

                //waiting for all builders to return - now we can callback the caller.
                if (ctx.numBuilders == ctx.numCallbacksFromBuilders) {
                    ctx.callback.call(ctx.assetInfos);
                    requests.remove(requestId);
                }
            }
        };
    }

    protected static int getNewRequestId(){

        int returnValue;
        synchronized (requests) {
            returnValue = lastRequestId;
            lastRequestId++;
        }

        return returnValue;
    }

    public void cancellBuildAssetInfosRequest(int currentRequestId) {
        DataForPhraseRequestContext ctx =requests.get(currentRequestId);
        if(ctx != null){
            if (ctx.builders == null)
                return;

            for (IPhraseAssetInfoBuilder builder : ctx.builders){
                builder.cancelAllInProgressRequests();
            }

            requests.remove(currentRequestId);
        }
    }

    //TODO: Once we move to V3 and everything is standardized, these can be non abstract (implemntation like in the AnimatedGif inheritor)
    // and we can delete lots of code from inheriting classes
    public abstract Phrase getReferencePhrase(JsonParser parser, Phrase phrase);

    public abstract boolean isEmpty();

    public abstract int buildAssetInfos(AniwaysAction<List<IAniwaysAssetInfo>> callback, Phrase phrase);
}
