package com.aniways.data;

import java.util.LinkedList;
import java.util.List;

//TODO: This needs to be generalized, with an interface from which an AniwaysPhraseEmoticonsUrlsBuilderProvider would also inherit
class AniwaysPhraseAnimatedGifsUrlsBuilderProvider {


    private static AniwaysPhraseAnimatedGifsUrlsBuilderProvider instance;
    private List<IPhraseAnimatedAssetInfoBuilder> builders;

    private AniwaysPhraseAnimatedGifsUrlsBuilderProvider() {
        initMembers();
    }

    public static AniwaysPhraseAnimatedGifsUrlsBuilderProvider getInstance(){
        if (instance == null)
            instance = new AniwaysPhraseAnimatedGifsUrlsBuilderProvider();

        return instance;
    }

    private void initMembers(){

        //Todo: all this initialisation should be done using dependency injection via IOC
        builders = new LinkedList<>();
        builders.add(new GiphyPhraseToAnimatedAssetInfoBuilder());
        //add Aniways builder
        //add other providers here
    }

    public IPhraseAnimatedAssetInfoBuilder provide(String providerName){
        for (IPhraseAnimatedAssetInfoBuilder builder: builders){
            if (builder.canBuild(providerName)){
                return builder;
            }
        }

        return null;
    }
}
