package com.aniways.data;

import com.aniways.AssetType;
import com.aniways.service.utils.AniwaysAction;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/**
 * Created by Shai on 22/01/2015.
 */
public class AniwaysPharseContentModelBuilder {
    private static final int EMPTY_REQUEST_ID = -1;
    private AniwaysAction<AniwaysPhraseToContentModel> callback;
    private AniwaysPhraseToContentModel model;
    private boolean duringFetchingProcess;
    private int currentRequestId = EMPTY_REQUEST_ID;
    private DataForAssetTypeInPhrase assetTypeData;
    private static HashMap<AssetType, AniwaysPharseContentModelBuilder> instances = new HashMap<>();
    private AssetType assetType;

    public AniwaysPharseContentModelBuilder(AssetType assetType) {
        this.assetType = assetType;
    }

    public static AniwaysPharseContentModelBuilder getInstance(AssetType assetType){
        AniwaysPharseContentModelBuilder instance = instances.get(assetType);
        if (instance == null) {
            instance = new AniwaysPharseContentModelBuilder(assetType);
            instances.put(assetType,instance);
        }

        return instance;
    }

    public void extract(Phrase phrase, final AniwaysAction<AniwaysPhraseToContentModel> callback) {
        //There might be a case which we are in the middle of fetching urls for previous phrase,
        // if so cancel all processing request and restart fetching for the new phrase
        if (duringFetchingProcess == true) {
            cancelAllgetDataForAssetTypeRequests();
        }

        JsonParser parser = AniwaysPhraseReplacementData.getDataParser();
        DataForAssetTypeInPhrase assetTypeData = phrase.getDataForAssetType(assetType);
        Phrase referencePhrase = assetTypeData.getReferencePhrase(parser, phrase);
        // The reference phrase can also be the same phrase, null means that we are not supposed to get data for this phrase at all, not even from reference phrases
        if (referencePhrase != null) { //override the original phrase with the referenced one.
            phrase = referencePhrase;
        } else {
            callback.call(null);
            return;
        }

        resetMembers(callback);

        if (phrase == null) {
            callback.call(null);
            return;
        }

        final Phrase finalPhrase = phrase;

        // We get again since now its the reference phrase
        this.assetTypeData = phrase.getDataForAssetType(assetType);
        if (this.assetTypeData == null || this.assetTypeData.isEmpty()) {
            callback.call(null);
            return;
        }

        this.currentRequestId = this.assetTypeData.buildAssetInfos(new AniwaysAction<List<IAniwaysAssetInfo>>(){

            @Override
            public void call(List<IAniwaysAssetInfo> assetInfos) {
                if (assetInfos != null && !assetInfos.isEmpty()){
                    model.addAssetInfos(assetInfos);
                    callback.call(model);
                }
            }
        }, finalPhrase);
    }

    private void resetMembers(AniwaysAction<AniwaysPhraseToContentModel> callback) {
        this.callback = callback;
        this.model = new AniwaysPhraseAnimatedGifsModel();
        this.duringFetchingProcess = false;
        this.currentRequestId = EMPTY_REQUEST_ID;
        this.assetTypeData = null;
    }

    private void cancelAllgetDataForAssetTypeRequests() {
        if(assetTypeData != null && currentRequestId != EMPTY_REQUEST_ID){
            assetTypeData.cancellBuildAssetInfosRequest(currentRequestId);
        }
    }
}
