package com.aniways.data;

import com.aniways.IconData;
import com.aniways.service.utils.AniwaysAction;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/**
 * Created by Shai on 22/01/2015.
 */
public class AnimatedGifsDataForPhrase extends DataForAssetTypeInPhrase {
    public static final AnimatedGifsDataForPhrase SEARCH_PHRASE_IN_ALL_PROVIDERS = initSearchPhraseInAllProvidersInstance();

    private static AnimatedGifsDataForPhrase initSearchPhraseInAllProvidersInstance() {
        HashMap<String, String[]> map = new HashMap<>();
        map.put(AnimatedGifsProviders.GIPHY.getStringRepresentaion(), null);
        AnimatedGifsDataForPhrase instance = new AnimatedGifsDataForPhrase(map);
        return instance;
    }

    HashMap<String, String[]> dataForAssetType;

    public AnimatedGifsDataForPhrase(HashMap<String, String[]> dataForAssetType){
        // TODO: this should be in the base class since in V3 all asset data will look like this
        //       then inheritors could have methods to parse this in whatever way they want
        this.dataForAssetType = dataForAssetType;
    }

    @Override
    public Phrase getReferencePhrase(JsonParser parser, Phrase phrase) {
        //Todo: uncomment this once the new json with the translation is available and also remove the phrase param:
        //return parser.getPhraseByName(get(AnimatedGifsProviders.INTERNAL_REFERENCE.getStringRepresentaion())[0]);

        //Todo: this is a hack for supporting other languages than english using the primary phrase, this will be romved once the new json is available:
        return extractPrimaryPharse(phrase);
    }

    @Override
    public boolean isEmpty() {
        return dataForAssetType.isEmpty();
    }

    @Override
    public int buildAssetInfos(final AniwaysAction<List<IAniwaysAssetInfo>> callback, Phrase phrase) {
        //TODO: Right now the caller of this method calls the getReferencePhrase method - this logic should be here instead

        // If there are no content providers, return null
        if(this.isEmpty()){
            callback.call(null);
            return -1;
        }

        AniwaysPhraseAnimatedGifsUrlsBuilderProvider builders = AniwaysPhraseAnimatedGifsUrlsBuilderProvider.getInstance();

        HashMap<IPhraseAnimatedAssetInfoBuilder, String[]> matchedBuilders = new HashMap<>();

        for (Map.Entry<String, String[]> entry : this.dataForAssetType.entrySet()) {
            String providerName = entry.getKey();
            String[] providerData = entry.getValue();
            if(this == SEARCH_PHRASE_IN_ALL_PROVIDERS){
                providerData = new String[]{"search:" + phrase.getName()};
            }

            IPhraseAnimatedAssetInfoBuilder builder = builders.provide(providerName);

            if (builder == null) {
                continue;
            }

            matchedBuilders.put(builder, providerData);
        }

        //no matching builders found call back with null
        if (matchedBuilders.isEmpty()) {
            callback.call(null);
            return -1;
        }

        final DataForPhraseRequestContext ctx = new DataForPhraseRequestContext(matchedBuilders.keySet(), callback);
        final int requestId = getNewRequestId();
        requests.put(requestId, ctx);

        for (Map.Entry<IPhraseAnimatedAssetInfoBuilder, String[]> entry : matchedBuilders.entrySet()) {
            IPhraseAnimatedAssetInfoBuilder builder = entry.getKey();
            String[] data = entry.getValue();

            builder.build(data, getBuildersCallback(requestId, ctx));
        }

        return requestId;
    }

    private Phrase extractPrimaryPharse(Phrase phrase) {
        if (phrase == null){
            return null;
        }

        if (phrase.icons == null || phrase.icons.icons.length <=0){
            return null;
        }

        //search for the first not null primary phrase.
        for(IconData icon : phrase.icons.icons){
            Phrase primaryPhrase = icon.primaryPhrase;

            if (primaryPhrase != null){
                if(primaryPhrase.animatedGifs == null){
                    primaryPhrase.animatedGifs = SEARCH_PHRASE_IN_ALL_PROVIDERS;
                }

                return primaryPhrase;
            }
        }

        //try to use the original phrase.
        return phrase;
    }
}
