package com.aniways.blur;

import com.aniways.R;
import com.aniways.data.AniwaysPrivateConfig;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;


public class ContextualBubbleFrameLayout extends FrameLayout
{
	private ContextualBubbleView mBubbleView;
	private TextView mPoweredBy;
	private TextView mCreditBalance;
	private int mPointerHeight;
	private boolean arrowDown;

	public ContextualBubbleFrameLayout(Context context)
	{
		super(context);	
	}

	public ContextualBubbleFrameLayout(Context context, AttributeSet attrs)
	{
		super(context, attrs);
	}

	@Override
	protected void onFinishInflate(){
		mCreditBalance = (TextView)this.findViewById(R.id.aniways_quickaction_credits_balance);
		mBubbleView = (ContextualBubbleView)this.findViewById(R.id.aniways_contextual_popup_blured_linear_layout);
		mPointerHeight = mBubbleView.pointerHeight;
		if (mPoweredBy != null) {
			addMargins(mPoweredBy, 0, 0, 0, mPointerHeight);
		}
		arrowDown = true;
	}

	@Override
	protected void onLayout (boolean changed, int l, int t, int r, int b)
	{
		super.onLayout(changed, l, t, r, b);
		if (mPoweredBy != null) {
			
			if(AniwaysPrivateConfig.getInstance().removePoweredByAniways){
				if(mPoweredBy.getVisibility() != View.GONE){
					mPoweredBy.setVisibility(View.GONE);
				}
				return;
			}
			
			if (mPoweredBy.getVisibility() == View.VISIBLE) {
				return;
			}

			// Enable the 'Powered by' text if there is room to show it.
			// This is not done the other way around since we dont want its size
			// to
			// affect the
			// measure of the contextual popup before it is displayed and affect
			// the
			// calculations of where to display it
			// TODO: this is a temporary hack - at this stage the layouting it
			// still
			// not finished,
			// so the calculation is not necessarily correct - also we do not
			// take
			// care of margins
			mPoweredBy.measure(ViewGroup.LayoutParams.WRAP_CONTENT,
					ViewGroup.LayoutParams.WRAP_CONTENT);
			int poweredByWidthWithMode = mPoweredBy.getMeasuredWidth();
			int poweredByWidth = MeasureSpec.getSize(poweredByWidthWithMode);
			if ((poweredByWidth + mBubbleView.getPaddingLeft() + mBubbleView.getPaddingRight() + 10) < mBubbleView.getWidth()){
				mPoweredBy.setVisibility(View.VISIBLE);
			}
		}
	}

	public void setArrowDown(float center)
	{
		mBubbleView.setArrowDown(center);
		if(!arrowDown){
			if(mPoweredBy != null){
				addMargins(mPoweredBy, 0, 0, 0, mPointerHeight);
			}
			if(mCreditBalance != null){
				addMargins(mCreditBalance, 0, -mPointerHeight, 0, 0);
			}
		}

		arrowDown = true;
	}

	public void setArrowUp(float center) {
		mBubbleView.setArrowUp(center);
		if(arrowDown){
			if(mPoweredBy != null){
				addMargins(mPoweredBy, 0, 0, 0, -mPointerHeight);
			}
			if(mCreditBalance != null){
				addMargins(mCreditBalance, 0, mPointerHeight, 0, 0);
			}
		}

		arrowDown = false;
	}
	
	private static void addMargins (View v, int l, int t, int r, int b) {
	    if (v.getLayoutParams() instanceof MarginLayoutParams) {
	        MarginLayoutParams p = (MarginLayoutParams) v.getLayoutParams();
	        p.setMargins(p.leftMargin + l, p.topMargin + t, p.rightMargin + r, p.bottomMargin + b);
	        v.requestLayout();
	    }
	}
}
