package com.aniways.analytics.stats;

import com.aniways.Log;

/**
 * A utility class to time an operation, and log it
 * after its ended.
 *
 */
public class Stopwatch {

	private static final String TAG = "AniwaysAnalyticsStopwatch";
	private String msg;
	private long start;
	private long end;
	
	/**
	 * Create and start a new timed operation.
	 * @param msg Message representing the operation
	 */
	public Stopwatch(String msg) {
		this.msg = msg;
		start();
	}
	
	/**
	 * Start the operation
	 */
	public void start() {
		start = System.currentTimeMillis();
	}
	
	/**
	 * End the operation and log its result
	 */
	public void end() {
		end = System.currentTimeMillis();
		
		Log.i(TAG, msg + " finished in : " + duration() + " milliseconds.");
	}
	
	/**
	 * Returns the millisecond duration of this operation
	 * @return
	 */
	public long duration() {
		return end - start;
	}
	
	
}
