package com.aniways.analytics.models;

import java.util.Calendar;

import org.json.JSONObject;

public class Error extends Track {
	
	public final static String TYPE = "error";
	
	private static final String SEVERITY_KEY = "severity";
	
	public Error (JSONObject obj) {
		super(obj);
	}
	
	public Error(String severity, EventProperties properties, Calendar timestamp, Context context) {

		super(properties, timestamp, context);

		put("type", TYPE);
		
		setSeverity(severity);
	}

	public String getSeverity() {
		return this.optString(SEVERITY_KEY, null);
	}

	public void setSeverity(String screen) {
		this.put(SEVERITY_KEY, screen);
	}
}
