package com.aniways.analytics.models;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

public class Batch extends EasyJSONObject {

	private final static String BATCH_KEY = "batch";
	private final static String CONTEXT_KEY = "context";
	
	public Batch(List<BasePayload> batch) {
		setBatch(batch);
	}
	
	public Context getContext() {
		JSONObject object = getObject(CONTEXT_KEY);
		if (object == null) return null;
		else return new Context(object);
	}

	public void setContext(Context context) {
		this.put(CONTEXT_KEY, context);
	}

	public List<BasePayload> getBatch() {
		return this.<BasePayload>getArray(BATCH_KEY);
	}

	public void setBatch(List<BasePayload> batch) {
		this.put(BATCH_KEY, new JSONArray(batch));
	}

}