package com.aniways.analytics.info;

import com.aniways.Log;
import com.aniways.analytics.models.EasyJSONObject;
import org.json.JSONObject;

import android.content.Context;
import android.util.DisplayMetrics;
import android.view.WindowManager;

public class Display implements Info<JSONObject> {

	private static final String TAG = "AniwaysAnalyticsContextDisplay";

	@Override
	public String getKey() {
		return "display";
	}

	@Override
	public JSONObject get(Context context) {

		EasyJSONObject object = new EasyJSONObject();

		try{

			WindowManager manager = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);

			if (manager != null) {

				DisplayMetrics metrics = new DisplayMetrics();

				android.view.Display display = manager.getDefaultDisplay();
				display.getMetrics(metrics);

				object.put("height", metrics.heightPixels);
				object.put("width", metrics.widthPixels);

				object.put("density", metrics.density);
				object.put("densityDpi", metrics.densityDpi);
			}
		}
		catch (Exception ex) {
			Log.eToGaOnly(true, TAG, "Caught Exception in Display info", ex);
		}

		return object;
	}

}
