package com.aniways.analytics.flush;

import com.aniways.Log;
import com.aniways.analytics.NonThrowingRunnable;
import com.aniways.analytics.utils.LooperThreadWithHandler;
import com.aniways.data.AniwaysPrivateConfig;

import android.os.Handler;

public class FlushTimer extends LooperThreadWithHandler {

	private Runnable clock;
	private boolean active;
	private final static String TAG = "AniwaysFlushTimer";

	public FlushTimer(Runnable clock) {
		super(TAG);
		this.clock = clock;
	}

	@Override
	public synchronized void start() {
		super.start();

		try{
			active = true;
			scheduleTick();
		}
		catch(Throwable ex){
			Log.eToGaOnly(true, TAG, "Caught Exception in start of flush timer", ex);
		}
	}

	public void scheduleNow() {
		scheduleTick(0);
	}

	private void scheduleTick() {
		scheduleTick(AniwaysPrivateConfig.getInstance().analyticsFlushInterval);
	}

	private void scheduleTick(int frequencyMs) {

		if (!active) return;

		Handler handler = handler();

		handler.postDelayed(tick, frequencyMs);
	}

	private Runnable tick = new NonThrowingRunnable(TAG, "perform request in flush tick", "", true) {

		@Override
		public void innerRun() {
			if (active) {
				clock.run();

				scheduleTick();
			}
		}
	};

	@Override
	public boolean quit() {

		active = false;
		return super.quit();

	}
}
