package com.aniways;

import com.aniways.data.Phrase;

public interface IAniwaysImageSpan {
	public Phrase getPhrase();
	public IconData getIcon();
    public ImageSpanMetadata getImageSpanMetadata();
	public boolean isLoadingImageSpan();

    public class ImageSpanMetadata{
        public static final ImageSpanMetadata Empty = new ImageSpanMetadata(IconSelectionOrigin.Unknown, AssetType.Unknown, AssetProvider.Unknown);
        public IconSelectionOrigin iconSelectionOrigin;
        public AssetType assetType;
        public AssetProvider assetProvider;

        public ImageSpanMetadata(IconSelectionOrigin iconSelectionOrigin, AssetType assetType, AssetProvider assetProvider) {
            this.iconSelectionOrigin = iconSelectionOrigin;
            this.assetType = assetType;
            this.assetProvider = assetProvider;
        }

        public ImageSpanMetadata(IconData icon, IconSelectionOrigin iconSelectionOrigin) {
            this.iconSelectionOrigin = iconSelectionOrigin;
            this.assetType = icon.assetType;
            this.assetProvider = icon.assetProvider;
        }

        public boolean isManual() {
            return IconSelectionOrigin.isManual(iconSelectionOrigin);
        }

        public boolean isFromUnknownKeyboard() {
            return IconSelectionOrigin.isFromUnknownKeyboard(iconSelectionOrigin);
        }

        public boolean isFromAniwaysKeyboard() {
            return IconSelectionOrigin.isFromAniwaysKeyboard(iconSelectionOrigin);
        }

        public boolean isFromPaste() {
            return IconSelectionOrigin.isFromPaste(iconSelectionOrigin);
        }

        public boolean isFromUnknownSource() {
            return IconSelectionOrigin.isFromUnknownSource(iconSelectionOrigin);
        }

        public boolean wasSelectedThroughAniways() {
            return IconSelectionOrigin.wasSelectedThroughAniways(iconSelectionOrigin);
        }

        public boolean isFromContextualReplacement() {
            return IconSelectionOrigin.isFromContextualReplacement(iconSelectionOrigin);
        }

        public boolean isIconSentSeperatelyFromText() {
            return assetType != AssetType.Emoji && assetType != assetType.Emoticons;
        }
    }

    enum IconSelectionOrigin{
        Unknown,
        ContextualManual,
        ContextualAuto,
        Autoreplace,
        AniwaysKeyboard,
        AniwaysKeyboardGenious,
        OtherKeyboard,
        Paste;

        public static boolean wasSelectedThroughAniways(IconSelectionOrigin selectionOrigin) {
            // Consider doing this by giving an ordinal range to those origins
            return selectionOrigin == IconSelectionOrigin.AniwaysKeyboard || selectionOrigin == IconSelectionOrigin.ContextualAuto || selectionOrigin == IconSelectionOrigin.ContextualManual
                    || selectionOrigin == IconSelectionOrigin.Autoreplace || selectionOrigin == IconSelectionOrigin.AniwaysKeyboardGenious;
        }

        public static boolean isFromContextualReplacement(IconSelectionOrigin selectionOrigin) {
            // Consider doing this by giving an ordinal range to those origins
            return selectionOrigin == IconSelectionOrigin.ContextualAuto || selectionOrigin == IconSelectionOrigin.ContextualManual || selectionOrigin == IconSelectionOrigin.Autoreplace;
        }

        public static boolean isManual(IconSelectionOrigin selectionOrigin) {
            return selectionOrigin == IconSelectionOrigin.ContextualManual;
        }

        public static boolean isFromUnknownKeyboard(IconSelectionOrigin selectionOrigin) {
            return selectionOrigin == IconSelectionOrigin.OtherKeyboard;
        }

        public static boolean isFromAniwaysKeyboard(IconSelectionOrigin selectionOrigin) {
            return selectionOrigin == IconSelectionOrigin.AniwaysKeyboard;
        }

        public static boolean isFromPaste(IconSelectionOrigin selectionOrigin) {
            return selectionOrigin == IconSelectionOrigin.Paste;
        }

        public static boolean isFromUnknownSource(IconSelectionOrigin selectionOrigin) {
            return selectionOrigin == IconSelectionOrigin.Unknown;
        }
    }

    enum AssetProvider{
        Unknown,
        Aniways,
        Giphy
    }
}
