package com.aniways;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.text.Editable;
import android.text.Spanned;

import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.data.Phrase;
import com.aniways.nineoldandroids.animation.ObjectAnimator;
import com.aniways.nineoldandroids.animation.ValueAnimator;
import com.aniways.nineoldandroids.animation.ValueAnimator.AnimatorUpdateListener;

public class AniwaysInteractiveImageSpan extends AniwaysImageSpan implements IAniwaysDynamicImageSpan
{
	private static final String TAG = "AniwaysAnimatedImageSpan";
	final private Editable mText;
	private float factor = 1;
	private ObjectAnimator mSpanAnimation;

	public AniwaysInteractiveImageSpan(Bitmap image, Phrase phrase, IconData icon, IconSelectionOrigin selectionOrigin, Context context, int width, int height, Editable text) {
		super(image, phrase, icon, selectionOrigin, context, width, height);
		this.mText = text;
		animate();
	}

	@Override
	public void draw(Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, Paint paint) {
		canvas.save();

		int transY = bottom - getDrawable().getBounds().bottom;
		if (mVerticalAlignment == ALIGN_BASELINE) {
			transY -= paint.getFontMetricsInt().descent;
		}
		canvas.translate(x, transY);
		Rect bounds = getDrawable().getBounds();
		canvas.scale(factor, factor, 
				bounds.left + bounds.width()  / 2, 
				bounds.top  + bounds.height() / 2);

		getDrawable().draw(canvas);
		canvas.restore();
	}

	public void setPulsate(float step){
		factor = step/100;
	}

	private void animate(){
		try{
			int pulsateAnimationFrom = AniwaysPrivateConfig.getInstance().pulsateAnimationFrom;
			int pulsateAnimationTo = AniwaysPrivateConfig.getInstance().pulsateAnimationTo;
			float[] values = {pulsateAnimationFrom, pulsateAnimationTo};
			mSpanAnimation = ObjectAnimator.ofFloat(this, "Pulsate", values);
			mSpanAnimation.setDuration(AniwaysPrivateConfig.getInstance().pulsateAnimationDuration);
			mSpanAnimation.setRepeatCount(AniwaysPrivateConfig.getInstance().pulsateAnimationRepeatCount);
			mSpanAnimation.setRepeatMode(ValueAnimator.REVERSE);
			mSpanAnimation.start();
			mSpanAnimation.addUpdateListener(new AnimatorUpdateListener() {

				@Override
				public void onAnimationUpdate(ValueAnimator arg0) {
					try{
						invalidateSelf();
					} catch (Throwable t){
						Log.e(true, TAG, "Exception when invalidating self", t);
					}
				}
			});
		} catch (Throwable t){
			Log.e(true, TAG, "Exception when animating span", t);
		}
	}
	
	private void stopAnimation(){
		mSpanAnimation.cancel();
	}

	private void invalidateSelf() {
		//TODO: For performsnce - add ways, like in loading image span, to know when this is attached and detached
		// and start/stop animation accordingly
		int end = mText.getSpanEnd(this);
		int start = mText.getSpanStart(this);

		if(start == -1 || end == -1){
			return;
		}

		mText.removeSpan(this);
		mText.setSpan(this, start, end, Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
	}

	@Override
	public void onDetachedFromWindowCalled() {
		Log.d(TAG, "detach called on interactive span. phrase: " + getPhrase() + ", iconId: " + getIcon().id);
		stopAnimation();
		
	}

	@Override
	public void onLayoutCalled() {
		Log.d(TAG, "layout called on interactive span. phrase: " + getPhrase() + ", iconId: " + getIcon().id);
		animate();
	}

	@Override
	public void onAddedToContainer(AniwaysDynamicImageSpansContainer container) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onRemovedFromContainer(AniwaysDynamicImageSpansContainer aniwaysDynamicImageSpansContainer) {
		// TODO Auto-generated method stub
		
	}
}