/*
 * Decompiled with CFR 0.152.
 */
package com.androidmapsextensions.utils;

public final class SphericalMercator {
    private static final double MIN_LATITUDE = -85.0511287798;
    private static final double MAX_LATITUDE = 85.0511287798;

    private SphericalMercator() {
    }

    public static double fromLatitude(double latitude) {
        double radians = Math.toRadians(latitude + 90.0) / 2.0;
        return Math.toDegrees(Math.log(Math.tan(radians)));
    }

    public static double toLatitude(double mercator) {
        double radians = Math.atan(Math.exp(Math.toRadians(mercator)));
        return Math.toDegrees(2.0 * radians) - 90.0;
    }

    public static double scaleLatitude(double latitude) {
        if (latitude < -85.0511287798) {
            latitude = -85.0511287798;
        } else if (latitude > 85.0511287798) {
            latitude = 85.0511287798;
        }
        return SphericalMercator.fromLatitude(latitude) + 180.0;
    }

    public static double scaleLongitude(double longitude) {
        return longitude + 180.0;
    }
}

