/*
 * Decompiled with CFR 0.152.
 */
package com.androidmapsextensions.impl;

import com.androidmapsextensions.TileOverlay;
import com.androidmapsextensions.TileOverlayOptions;
import com.androidmapsextensions.impl.DelegatingTileOverlay;
import com.androidmapsextensions.impl.IGoogleMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class TileOverlayManager {
    private final IGoogleMap factory;
    private final Map<com.google.android.gms.maps.model.TileOverlay, TileOverlay> tileOverlays;

    public TileOverlayManager(IGoogleMap factory) {
        this.factory = factory;
        this.tileOverlays = new HashMap<com.google.android.gms.maps.model.TileOverlay, TileOverlay>();
    }

    public TileOverlay addTileOverlay(TileOverlayOptions tileOverlayOptions) {
        TileOverlay tileOverlay = this.createTileOverlay(tileOverlayOptions.real);
        tileOverlay.setData(tileOverlayOptions.getData());
        return tileOverlay;
    }

    private TileOverlay createTileOverlay(com.google.android.gms.maps.model.TileOverlayOptions tileOverlayOptions) {
        com.google.android.gms.maps.model.TileOverlay real = this.factory.addTileOverlay(tileOverlayOptions);
        DelegatingTileOverlay tileOverlay = new DelegatingTileOverlay(real, this);
        this.tileOverlays.put(real, tileOverlay);
        return tileOverlay;
    }

    public void clear() {
        this.tileOverlays.clear();
    }

    public List<TileOverlay> getTileOverlays() {
        return new ArrayList<TileOverlay>(this.tileOverlays.values());
    }

    public void onRemove(com.google.android.gms.maps.model.TileOverlay real) {
        this.tileOverlays.remove(real);
    }
}

