/*
 * Decompiled with CFR 0.152.
 */
package com.androidmapsextensions.impl;

import com.androidmapsextensions.GoogleMap;
import com.androidmapsextensions.Polyline;
import com.androidmapsextensions.PolylineOptions;
import com.androidmapsextensions.impl.DelegatingPolyline;
import com.androidmapsextensions.impl.IGoogleMap;
import com.google.android.gms.maps.GoogleMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class PolylineManager {
    private final IGoogleMap factory;
    private final Map<com.google.android.gms.maps.model.Polyline, Polyline> polylines;

    public PolylineManager(IGoogleMap factory) {
        this.factory = factory;
        this.polylines = new HashMap<com.google.android.gms.maps.model.Polyline, Polyline>();
    }

    public Polyline addPolyline(PolylineOptions polylineOptions) {
        Polyline polyline = this.createPolyline(polylineOptions.real);
        polyline.setData(polylineOptions.getData());
        return polyline;
    }

    private Polyline createPolyline(com.google.android.gms.maps.model.PolylineOptions polylineOptions) {
        com.google.android.gms.maps.model.Polyline real = this.factory.addPolyline(polylineOptions);
        DelegatingPolyline polyline = new DelegatingPolyline(real, this);
        this.polylines.put(real, polyline);
        return polyline;
    }

    public void clear() {
        this.polylines.clear();
    }

    public List<Polyline> getPolylines() {
        return new ArrayList<Polyline>(this.polylines.values());
    }

    public void onRemove(com.google.android.gms.maps.model.Polyline real) {
        this.polylines.remove(real);
    }

    public void setOnPolylineClickListener(GoogleMap.OnPolylineClickListener onPolylineClickListener) {
        DelegatingOnPolylineClickListener realOnPolylineClickListener = null;
        if (onPolylineClickListener != null) {
            realOnPolylineClickListener = new DelegatingOnPolylineClickListener(onPolylineClickListener);
        }
        this.factory.setOnPolylineClickListener(realOnPolylineClickListener);
    }

    private class DelegatingOnPolylineClickListener
    implements GoogleMap.OnPolylineClickListener {
        private final GoogleMap.OnPolylineClickListener onPolylineClickListener;

        public DelegatingOnPolylineClickListener(GoogleMap.OnPolylineClickListener onPolylineClickListener) {
            this.onPolylineClickListener = onPolylineClickListener;
        }

        public void onPolylineClick(com.google.android.gms.maps.model.Polyline polyline) {
            this.onPolylineClickListener.onPolylineClick((Polyline)PolylineManager.this.polylines.get(polyline));
        }
    }
}

