/*
 * Decompiled with CFR 0.152.
 */
package com.androidmapsextensions.impl;

import com.androidmapsextensions.Marker;
import com.androidmapsextensions.impl.ClusteringStrategy;
import com.androidmapsextensions.impl.DelegatingMarker;
import com.androidmapsextensions.impl.IGoogleMap;
import com.androidmapsextensions.impl.IProjection;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.VisibleRegion;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

class DynamicNoClusteringStrategy
implements ClusteringStrategy {
    private IGoogleMap map;
    private Set<DelegatingMarker> markers = new HashSet<DelegatingMarker>();
    private LatLngBounds visibleRegionBounds;

    public DynamicNoClusteringStrategy(IGoogleMap map, List<DelegatingMarker> markers) {
        this.map = map;
        for (DelegatingMarker marker : markers) {
            if (!marker.isVisible()) continue;
            this.markers.add(marker);
        }
        this.showMarkersInVisibleRegion();
    }

    @Override
    public void cleanup() {
        this.markers.clear();
    }

    @Override
    public void onCameraChange(CameraPosition cameraPosition) {
        this.showMarkersInVisibleRegion();
    }

    @Override
    public void onClusterGroupChange(DelegatingMarker marker) {
    }

    @Override
    public void onAdd(DelegatingMarker marker) {
        if (!marker.isVisible()) {
            return;
        }
        this.addMarker(marker);
    }

    @Override
    public void onRemove(DelegatingMarker marker) {
        if (!marker.isVisible()) {
            return;
        }
        this.markers.remove(marker);
    }

    @Override
    public void onPositionChange(DelegatingMarker marker) {
        if (!marker.isVisible()) {
            return;
        }
        if (this.markers.contains(marker) && this.visibleRegionBounds.contains(marker.getPosition())) {
            this.markers.remove(marker);
            marker.changeVisible(true);
        }
    }

    @Override
    public void onVisibilityChangeRequest(DelegatingMarker marker, boolean visible) {
        if (visible) {
            this.addMarker(marker);
        } else {
            this.markers.remove(marker);
            marker.changeVisible(false);
        }
    }

    @Override
    public void onShowInfoWindow(DelegatingMarker marker) {
        if (!marker.isVisible()) {
            return;
        }
        if (this.markers.remove(marker)) {
            marker.changeVisible(true);
        }
        marker.forceShowInfoWindow();
    }

    @Override
    public Marker map(com.google.android.gms.maps.model.Marker original) {
        return null;
    }

    @Override
    public List<Marker> getDisplayedMarkers() {
        return null;
    }

    @Override
    public float getMinZoomLevelNotClustered(Marker marker) {
        return 0.0f;
    }

    private void showMarkersInVisibleRegion() {
        IProjection projection = this.map.getProjection();
        VisibleRegion visibleRegion = projection.getVisibleRegion();
        this.visibleRegionBounds = visibleRegion.latLngBounds;
        Iterator<DelegatingMarker> iterator = this.markers.iterator();
        while (iterator.hasNext()) {
            DelegatingMarker marker = iterator.next();
            if (!this.visibleRegionBounds.contains(marker.getPosition())) continue;
            marker.changeVisible(true);
            iterator.remove();
        }
    }

    private void addMarker(DelegatingMarker marker) {
        if (this.visibleRegionBounds.contains(marker.getPosition())) {
            marker.changeVisible(true);
        } else {
            this.markers.add(marker);
        }
    }
}

