/*
 * Decompiled with CFR 0.152.
 */
package com.androidmapsextensions.impl;

import com.androidmapsextensions.Circle;
import com.androidmapsextensions.impl.CircleManager;
import com.androidmapsextensions.utils.LatLngUtils;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PatternItem;
import java.util.List;

class DelegatingCircle
implements Circle {
    private com.google.android.gms.maps.model.Circle real;
    private CircleManager manager;
    private Object data;

    DelegatingCircle(com.google.android.gms.maps.model.Circle real, CircleManager manager) {
        this.real = real;
        this.manager = manager;
    }

    @Override
    public boolean contains(LatLng position) {
        LatLng center = this.getCenter();
        double radius = this.getRadius();
        float distance = LatLngUtils.distanceBetween(position, center);
        return (double)distance < radius;
    }

    @Override
    public LatLng getCenter() {
        return this.real.getCenter();
    }

    public Object getData() {
        return this.data;
    }

    @Override
    public int getFillColor() {
        return this.real.getFillColor();
    }

    @Override
    @Deprecated
    public String getId() {
        return this.real.getId();
    }

    @Override
    public double getRadius() {
        return this.real.getRadius();
    }

    @Override
    public int getStrokeColor() {
        return this.real.getStrokeColor();
    }

    @Override
    public List<PatternItem> getStrokePattern() {
        return this.real.getStrokePattern();
    }

    @Override
    public float getStrokeWidth() {
        return this.real.getStrokeWidth();
    }

    @Override
    public Object getTag() {
        return this.real.getTag();
    }

    @Override
    public float getZIndex() {
        return this.real.getZIndex();
    }

    @Override
    public boolean isClickable() {
        return this.real.isClickable();
    }

    @Override
    public boolean isVisible() {
        return this.real.isVisible();
    }

    @Override
    public void remove() {
        this.manager.onRemove(this.real);
        this.real.remove();
    }

    @Override
    public void setCenter(LatLng center) {
        this.real.setCenter(center);
    }

    @Override
    public void setClickable(boolean clickable) {
        this.real.setClickable(clickable);
    }

    @Override
    public void setData(Object data) {
        this.data = data;
    }

    @Override
    public void setFillColor(int fillColor) {
        this.real.setFillColor(fillColor);
    }

    @Override
    public void setRadius(double radius) {
        this.real.setRadius(radius);
    }

    @Override
    public void setStrokeColor(int strokeColor) {
        this.real.setStrokeColor(strokeColor);
    }

    @Override
    public void setStrokePattern(List<PatternItem> strokePattern) {
        this.real.setStrokePattern(strokePattern);
    }

    @Override
    public void setStrokeWidth(float strokeWidth) {
        this.real.setStrokeWidth(strokeWidth);
    }

    @Override
    public void setTag(Object tag) {
        this.real.setTag(tag);
    }

    @Override
    public void setVisible(boolean visible) {
        this.real.setVisible(visible);
    }

    @Override
    public void setZIndex(float zIndex) {
        this.real.setZIndex(zIndex);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DelegatingCircle)) {
            return false;
        }
        DelegatingCircle other = (DelegatingCircle)o;
        return this.real.equals((Object)other.real);
    }

    public int hashCode() {
        return this.real.hashCode();
    }

    public String toString() {
        return this.real.toString();
    }
}

