/*
 * Decompiled with CFR 0.152.
 */
package com.androidmapsextensions.impl;

import android.os.Handler;
import android.os.Message;
import com.androidmapsextensions.impl.ClusterMarker;
import java.util.HashSet;
import java.util.Set;

class ClusterRefresher {
    private Set<ClusterMarker> refreshQueue = new HashSet<ClusterMarker>();
    private boolean refreshPending;
    private Handler refresher = new Handler(new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            ClusterRefresher.this.refreshAll();
            return true;
        }
    });

    ClusterRefresher() {
    }

    void refresh(ClusterMarker cluster) {
        this.refreshQueue.add(cluster);
        if (!this.refreshPending) {
            this.refresher.sendEmptyMessage(0);
            this.refreshPending = true;
        }
    }

    void cleanup() {
        this.refreshQueue.clear();
        this.refreshPending = false;
        this.refresher.removeMessages(0);
    }

    void refreshAll() {
        for (ClusterMarker cluster : this.refreshQueue) {
            cluster.refresh();
        }
        this.cleanup();
    }
}

