/*
 * Decompiled with CFR 0.152.
 */
package com.androidmapsextensions;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.support.v4.util.LruCache;
import com.androidmapsextensions.ClusterOptions;
import com.androidmapsextensions.ClusterOptionsProvider;
import com.androidmapsextensions.Marker;
import com.androidmapsextensions.R;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.BitmapDescriptorFactory;
import java.util.List;

public class DefaultClusterOptionsProvider
implements ClusterOptionsProvider {
    private final LruCache<Integer, BitmapDescriptor> cache = new LruCache(128);
    private final ClusterOptions clusterOptions = new ClusterOptions().anchor(0.5f, 0.5f);
    private final int[] colors;
    private final Paint circlePaint;
    private final Paint circleShadowPaint;
    private final Paint textPaint;
    private final Rect bounds = new Rect();
    private float blurRadius;
    private float textPadding;
    private float shadowBlurRadius;
    private float shadowOffsetX;
    private float shadowOffsetY;

    public DefaultClusterOptionsProvider(Resources resources) {
        this.colors = new int[]{resources.getColor(R.color.ame_default_cluster_circle_color_small), resources.getColor(R.color.ame_default_cluster_circle_color_medium), resources.getColor(R.color.ame_default_cluster_circle_color_large), resources.getColor(R.color.ame_default_cluster_circle_color_extra_large)};
        this.circlePaint = this.createCirclePaint(resources);
        this.circleShadowPaint = this.createCircleShadowPaint(resources);
        this.textPaint = this.createTextPaint(resources);
        this.textPadding = resources.getDimension(R.dimen.ame_default_cluster_text_padding);
    }

    private Paint createCirclePaint(Resources resources) {
        Paint paint = new Paint(1);
        this.blurRadius = resources.getDimension(R.dimen.ame_default_cluster_circle_blur_radius);
        if (this.blurRadius > 0.0f) {
            BlurMaskFilter maskFilter = new BlurMaskFilter(this.blurRadius, BlurMaskFilter.Blur.SOLID);
            paint.setMaskFilter((MaskFilter)maskFilter);
        }
        return paint;
    }

    private Paint createCircleShadowPaint(Resources resources) {
        Paint paint = null;
        float circleShadowBlurRadius = resources.getDimension(R.dimen.ame_default_cluster_circle_shadow_blur_radius);
        if (circleShadowBlurRadius > 0.0f) {
            paint = new Paint(1);
            float offsetX = resources.getDimension(R.dimen.ame_default_cluster_circle_shadow_offset_x);
            float offsetY = resources.getDimension(R.dimen.ame_default_cluster_circle_shadow_offset_y);
            int color2 = resources.getColor(R.color.ame_default_cluster_circle_shadow_color);
            paint.setShadowLayer(circleShadowBlurRadius, offsetX, offsetY, color2);
        }
        return paint;
    }

    private Paint createTextPaint(Resources resources) {
        Paint paint = new Paint(1);
        paint.setColor(resources.getColor(R.color.ame_default_cluster_text_color));
        this.shadowBlurRadius = resources.getDimension(R.dimen.ame_default_cluster_text_shadow_blur_radius);
        if (this.shadowBlurRadius > 0.0f) {
            this.shadowOffsetX = resources.getDimension(R.dimen.ame_default_cluster_text_shadow_offset_x);
            this.shadowOffsetY = resources.getDimension(R.dimen.ame_default_cluster_text_shadow_offset_y);
            int shadowColor = resources.getColor(R.color.ame_default_cluster_text_shadow_color);
            paint.setShadowLayer(this.shadowBlurRadius, this.shadowOffsetX, this.shadowOffsetY, shadowColor);
        }
        paint.setTextSize(resources.getDimension(R.dimen.ame_default_cluster_text_size));
        paint.setTypeface(Typeface.DEFAULT_BOLD);
        return paint;
    }

    @Override
    public ClusterOptions getClusterOptions(List<Marker> markers) {
        int count = markers.size();
        BitmapDescriptor icon = (BitmapDescriptor)this.cache.get((Object)count);
        if (icon == null) {
            icon = this.createIcon(count);
            this.cache.put((Object)count, (Object)icon);
        }
        this.clusterOptions.icon(icon);
        return this.clusterOptions;
    }

    private BitmapDescriptor createIcon(int count) {
        String text = String.valueOf(count);
        this.calculateTextSize(text);
        int iconSize = this.calculateIconSize();
        Bitmap bitmap = Bitmap.createBitmap((int)iconSize, (int)iconSize, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        this.drawCircle(canvas, count, iconSize);
        this.drawText(canvas, text, iconSize);
        return BitmapDescriptorFactory.fromBitmap((Bitmap)bitmap);
    }

    private void calculateTextSize(String text) {
        this.textPaint.getTextBounds(text, 0, text.length(), this.bounds);
    }

    private int calculateIconSize() {
        int w = this.bounds.width();
        int h = this.bounds.height();
        return (int)Math.ceil((double)(2.0f * (this.textPadding + this.blurRadius)) + Math.sqrt(w * w + h * h));
    }

    private void drawCircle(Canvas canvas, int count, float iconSize) {
        canvas.drawCircle(iconSize / 2.0f, iconSize / 2.0f, iconSize / 2.0f - this.blurRadius, this.circleShadowPaint);
        for (int i = this.colors.length - 1; i >= 0; --i) {
            if (!((double)count >= Math.pow(10.0, i))) continue;
            this.circlePaint.setColor(this.colors[i]);
            break;
        }
        canvas.drawCircle(iconSize / 2.0f, iconSize / 2.0f, iconSize / 2.0f - this.blurRadius, this.circlePaint);
    }

    private void drawText(Canvas canvas, String text, int iconSize) {
        int x = Math.round((float)((iconSize - this.bounds.width()) / 2 - this.bounds.left) - this.shadowOffsetX / 2.0f);
        int y = Math.round((float)((iconSize - this.bounds.height()) / 2 - this.bounds.top) - this.shadowOffsetY / 2.0f);
        canvas.drawText(text, (float)x, (float)y, this.textPaint);
    }
}

