/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository;

import com.android.io.NonClosingInputStream;
import com.android.sdklib.internal.repository.DownloadCache;
import com.android.sdklib.internal.repository.ITaskMonitor;
import com.android.sdklib.repository.SdkAddonsListConstants;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLKeyException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

@Deprecated
public class AddonsListFetcher {
    public Site[] fetch(String url, DownloadCache cache, ITaskMonitor monitor) {
        int pos;
        String baseUrl;
        int version;
        url = url == null ? "" : url.trim();
        monitor.setProgressMax(6);
        monitor.setDescription("Fetching %1$s", url);
        monitor.incProgress(1);
        Exception[] exception = new Exception[]{null};
        Boolean[] validatorFound = new Boolean[]{Boolean.FALSE};
        String[] validationError = new String[]{null};
        Document validatedDoc = null;
        String validatedUri = null;
        String[] defaultNames = new String[2];
        int version2 = 2;
        int i = 0;
        while (version2 >= 1) {
            defaultNames[i] = SdkAddonsListConstants.getDefaultName(version2);
            --version2;
            ++i;
        }
        InputStream xml = this.fetchXmlUrl(url, cache, monitor.createSubMonitor(1), exception);
        if (xml != null && (version = this.getXmlSchemaVersion(xml)) == 0) {
            this.closeStream(xml);
            xml = null;
        }
        if (!(baseUrl = url).endsWith("/") && (pos = baseUrl.lastIndexOf(47)) > 0) {
            baseUrl = baseUrl.substring(0, pos + 1);
        }
        if (xml == null && defaultNames.length > 0) {
            ITaskMonitor subMonitor = monitor.createSubMonitor(1);
            subMonitor.setProgressMax(defaultNames.length);
            for (String name : defaultNames) {
                String newUrl = baseUrl + name;
                if (newUrl.equals(url) || (xml = this.fetchXmlUrl(newUrl, cache, subMonitor.createSubMonitor(1), exception)) == null) continue;
                int version3 = this.getXmlSchemaVersion(xml);
                if (version3 == 0) {
                    this.closeStream(xml);
                    xml = null;
                    continue;
                }
                url = newUrl;
                subMonitor.incProgress(subMonitor.getProgressMax() - subMonitor.getProgress());
                break;
            }
        } else {
            monitor.incProgress(1);
        }
        if (xml != null) {
            monitor.setDescription("Validate XML", new Object[0]);
            int version4 = this.getXmlSchemaVersion(xml);
            if (version4 >= 1 && version4 <= 2) {
                String uri = this.validateXml(xml, url, version4, validationError, validatorFound);
                if (uri != null) {
                    validatedDoc = this.getDocument(xml, monitor);
                    validatedUri = uri;
                }
            } else if (version4 > 2) {
                this.closeStream(xml);
                return null;
            }
        }
        if (exception[0] != null) {
            String reason = null;
            reason = exception[0] instanceof FileNotFoundException ? "File not found" : (exception[0] instanceof UnknownHostException && exception[0].getMessage() != null ? String.format("Unknown Host %1$s", exception[0].getMessage()) : (exception[0] instanceof SSLKeyException ? "HTTPS SSL error. You might want to force download through HTTP in the settings." : (exception[0].getMessage() != null ? exception[0].getMessage() : String.format("Unknown (%1$s)", exception[0].getClass().getName()))));
            monitor.logError("Failed to fetch URL %1$s, reason: %2$s", url, reason);
        }
        if (validationError[0] != null) {
            monitor.logError("%s", validationError[0]);
        }
        if (validatedDoc == null) {
            this.closeStream(xml);
            return null;
        }
        monitor.incProgress(1);
        Site[] result = null;
        if (xml != null) {
            monitor.setDescription("Parse XML", new Object[0]);
            monitor.incProgress(1);
            result = this.parseAddonsList(validatedDoc, validatedUri, baseUrl, monitor);
        }
        monitor.incProgress(1);
        this.closeStream(xml);
        return result;
    }

    private InputStream fetchXmlUrl(String urlString, DownloadCache cache, ITaskMonitor monitor, Exception[] outException) {
        try {
            InputStream xml = cache.openCachedUrl(urlString, monitor);
            if (xml != null) {
                xml.mark(500000);
                xml = new NonClosingInputStream(xml);
                ((NonClosingInputStream)xml).setCloseBehavior(NonClosingInputStream.CloseBehavior.RESET);
            }
            return xml;
        }
        catch (Exception e) {
            if (outException != null) {
                outException[0] = e;
            }
            return null;
        }
    }

    private void closeStream(InputStream is) {
        if (is != null) {
            if (is instanceof NonClosingInputStream) {
                ((NonClosingInputStream)is).setCloseBehavior(NonClosingInputStream.CloseBehavior.CLOSE);
            }
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected int getXmlSchemaVersion(InputStream xml) {
        if (xml == null) {
            return 0;
        }
        Node doc = null;
        try {
            assert (xml.markSupported());
            xml.reset();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringComments(false);
            factory.setValidating(false);
            factory.setNamespaceAware(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException e) throws SAXException {
                }

                @Override
                public void fatalError(SAXParseException e) throws SAXException {
                    throw e;
                }

                @Override
                public void error(SAXParseException e) throws SAXException {
                    throw e;
                }
            });
            doc = builder.parse(xml);
            factory.setNamespaceAware(true);
            builder = factory.newDocumentBuilder();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (doc == null) {
            return 0;
        }
        Pattern nsPattern = Pattern.compile("http://schemas.android.com/sdk/android/addons-list/([1-9][0-9]*)");
        String prefix = null;
        for (Node child = doc.getFirstChild(); child != null; child = child.getNextSibling()) {
            Matcher m;
            String uri;
            Node attr;
            if (child.getNodeType() != 1) continue;
            prefix = null;
            String name = child.getNodeName();
            int pos = name.indexOf(58);
            if (pos > 0 && pos < name.length() - 1) {
                prefix = name.substring(0, pos);
                name = name.substring(pos + 1);
            }
            if (!"sdk-addons-list".equals(name)) continue;
            NamedNodeMap attrs = child.getAttributes();
            String xmlns = "xmlns";
            if (prefix != null) {
                xmlns = xmlns + ":" + prefix;
            }
            if ((attr = attrs.getNamedItem(xmlns)) == null || (uri = attr.getNodeValue()) == null || !(m = nsPattern.matcher(uri)).matches()) continue;
            String version = m.group(1);
            try {
                return Integer.parseInt(version);
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        return 0;
    }

    protected String validateXml(InputStream xml, String url, int version, String[] outError, Boolean[] validatorFound) {
        if (xml == null) {
            return null;
        }
        try {
            Validator validator = this.getValidator(version);
            if (validator == null) {
                validatorFound[0] = Boolean.FALSE;
                outError[0] = String.format("XML verification failed for %1$s.\nNo suitable XML Schema Validator could be found in your Java environment. Please consider updating your version of Java.", url);
                return null;
            }
            validatorFound[0] = Boolean.TRUE;
            assert (xml.markSupported());
            xml.reset();
            validator.validate(new StreamSource(xml));
            return SdkAddonsListConstants.getSchemaUri(version);
        }
        catch (SAXParseException e) {
            outError[0] = String.format("XML verification failed for %1$s.\nLine %2$d:%3$d, Error: %4$s", url, e.getLineNumber(), e.getColumnNumber(), e.toString());
        }
        catch (Exception e) {
            outError[0] = String.format("XML verification failed for %1$s.\nError: %2$s", url, e.toString());
        }
        return null;
    }

    private Validator getValidator(int version) throws SAXException {
        InputStream xsdStream = SdkAddonsListConstants.getXsdStream(version);
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        if (factory == null) {
            return null;
        }
        Schema schema = factory.newSchema(new StreamSource(xsdStream));
        Validator validator = schema == null ? null : schema.newValidator();
        return validator;
    }

    protected Document getDocument(InputStream xml, ITaskMonitor monitor) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringComments(true);
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            assert (xml.markSupported());
            xml.reset();
            Document doc = builder.parse(new InputSource(xml));
            return doc;
        }
        catch (ParserConfigurationException e) {
            monitor.logError("Failed to create XML document builder", new Object[0]);
        }
        catch (SAXException e) {
            monitor.logError("Failed to parse XML document", new Object[0]);
        }
        catch (IOException e) {
            monitor.logError("Failed to read XML document", new Object[0]);
        }
        return null;
    }

    protected Site[] parseAddonsList(Document doc, String nsUri, String baseUrl, ITaskMonitor monitor) {
        Node root;
        String testBaseUrl = System.getenv("SDK_TEST_BASE_URL");
        if (!(testBaseUrl == null || testBaseUrl.length() > 0 && testBaseUrl.endsWith("/"))) {
            testBaseUrl = null;
        }
        if ((root = this.getFirstChild(doc, nsUri, "sdk-addons-list")) != null) {
            ArrayList<Site> sites = new ArrayList<Site>();
            for (Node child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 1 || !nsUri.equals(child.getNamespaceURI())) continue;
                String elementName = child.getLocalName();
                SiteType type = null;
                if ("sys-img-site".equals(elementName)) {
                    type = SiteType.SYS_IMG_SITE;
                } else if ("addon-site".equals(elementName)) {
                    type = SiteType.ADDON_SITE;
                }
                if (type == null) continue;
                Node url = this.getFirstChild(child, nsUri, "url");
                Node name = this.getFirstChild(child, nsUri, "name");
                if (name == null || url == null) continue;
                String strUrl = url.getTextContent().trim();
                String strName = name.getTextContent().trim();
                if (testBaseUrl != null && strUrl.startsWith("https://dl.google.com/android/repository/")) {
                    strUrl = testBaseUrl + strUrl.substring("https://dl.google.com/android/repository/".length());
                } else if (!strUrl.startsWith("http://") && !strUrl.startsWith("https://")) {
                    strUrl = baseUrl + strUrl;
                }
                if (strUrl.isEmpty() || strName.isEmpty()) continue;
                sites.add(new Site(strUrl, strName, type));
            }
            return sites.toArray(new Site[sites.size()]);
        }
        return null;
    }

    private Node getFirstChild(Node node, String nsUri, String xmlLocalName) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !nsUri.equals(child.getNamespaceURI()) || xmlLocalName != null && !child.getLocalName().equals(xmlLocalName)) continue;
            return child;
        }
        return null;
    }

    public static class Site {
        private final String mUrl;
        private final String mUiName;
        private final SiteType mType;

        private Site(String url, String uiName, SiteType type) {
            this.mType = type;
            this.mUrl = url.trim();
            this.mUiName = uiName;
        }

        public String getUrl() {
            return this.mUrl;
        }

        public String getUiName() {
            return this.mUiName;
        }

        public SiteType getType() {
            return this.mType;
        }

        public String toString() {
            return String.format("<%1$s URL='%2$s' Name='%3$s'>", new Object[]{this.mType, this.mUrl, this.mUiName});
        }
    }

    public static enum SiteType {
        ADDON_SITE,
        SYS_IMG_SITE;

    }
}

