/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.local;

import com.android.SdkConstants;
import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.internal.repository.packages.PackageParserUtils;
import com.android.sdklib.io.FileOp;
import com.android.sdklib.io.IFileOp;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.MajorRevision;
import com.android.sdklib.repository.NoPreviewRevision;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.PkgDescExtra;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.sdklib.repository.local.LocalAddonPkgInfo;
import com.android.sdklib.repository.local.LocalBuildToolPkgInfo;
import com.android.sdklib.repository.local.LocalDirInfo;
import com.android.sdklib.repository.local.LocalDocPkgInfo;
import com.android.sdklib.repository.local.LocalExtraPkgInfo;
import com.android.sdklib.repository.local.LocalPkgInfo;
import com.android.sdklib.repository.local.LocalPlatformPkgInfo;
import com.android.sdklib.repository.local.LocalPlatformToolPkgInfo;
import com.android.sdklib.repository.local.LocalSamplePkgInfo;
import com.android.sdklib.repository.local.LocalSourcePkgInfo;
import com.android.sdklib.repository.local.LocalSysImgPkgInfo;
import com.android.sdklib.repository.local.LocalToolPkgInfo;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Properties;

public class LocalSdk {
    private File mSdkRoot;
    private final IFileOp mFileOp;
    private final Multimap<PkgType, LocalPkgInfo> mLocalPackages = TreeMultimap.create();
    private final Multimap<PkgType, LocalDirInfo> mVisitedDirs = HashMultimap.create();
    private BuildToolInfo mLegacyBuildTools;
    private IAndroidTarget[] mCachedTargets;

    public LocalSdk() {
        this.mFileOp = new FileOp();
    }

    public LocalSdk(@NonNull File sdkRoot) {
        this();
        this.setLocation(sdkRoot);
    }

    protected LocalSdk(@NonNull IFileOp fileOp) {
        this.mFileOp = fileOp;
    }

    @NonNull
    public IFileOp getFileOp() {
        return this.mFileOp;
    }

    public void setLocation(@NonNull File sdkRoot) {
        assert (sdkRoot != null);
        this.mSdkRoot = sdkRoot;
        this.clearLocalPkg(PkgType.PKG_ALL);
    }

    @Nullable
    public File getLocation() {
        return this.mSdkRoot;
    }

    public void clearLocalPkg(@NonNull EnumSet<PkgType> filters) {
        this.mCachedTargets = null;
        this.mLegacyBuildTools = null;
        for (PkgType filter : filters) {
            this.mVisitedDirs.removeAll((Object)filter);
            this.mLocalPackages.removeAll((Object)filter);
        }
    }

    public boolean hasChanged(@NonNull EnumSet<PkgType> filters) {
        for (PkgType filter : filters) {
            for (LocalDirInfo dirInfo : this.mVisitedDirs.get((Object)filter)) {
                if (!dirInfo.hasChanged()) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public LocalPkgInfo getPkgInfo(@NonNull PkgType filter, @NonNull AndroidVersion version) {
        assert (filter == PkgType.PKG_PLATFORMS || filter == PkgType.PKG_SAMPLES || filter == PkgType.PKG_SOURCES);
        for (LocalPkgInfo pkg : this.getPkgsInfos(filter)) {
            IPkgDesc d = pkg.getDesc();
            if (!d.hasAndroidVersion() || !d.getAndroidVersion().equals(version)) continue;
            return pkg;
        }
        return null;
    }

    @Nullable
    public LocalPkgInfo getPkgInfo(@NonNull PkgType filter, @NonNull FullRevision revision) {
        assert (filter == PkgType.PKG_BUILD_TOOLS);
        for (LocalPkgInfo pkg : this.getPkgsInfos(filter)) {
            IPkgDesc d = pkg.getDesc();
            if (!d.hasFullRevision() || !d.getFullRevision().equals(revision)) continue;
            return pkg;
        }
        return null;
    }

    @Nullable
    public LocalPkgInfo getPkgInfo(@NonNull PkgType filter, @NonNull String path) {
        assert (filter == PkgType.PKG_ADDONS || filter == PkgType.PKG_PLATFORMS);
        for (LocalPkgInfo pkg : this.getPkgsInfos(filter)) {
            IPkgDesc d = pkg.getDesc();
            if (!d.hasPath() || !path.equals(d.getPath())) continue;
            return pkg;
        }
        return null;
    }

    @Nullable
    public LocalPkgInfo getPkgInfo(@NonNull PkgType filter, @NonNull String vendor, @NonNull String path) {
        assert (filter == PkgType.PKG_EXTRAS || filter == PkgType.PKG_ADDONS);
        for (LocalPkgInfo pkg : this.getPkgsInfos(filter)) {
            IPkgDesc d = pkg.getDesc();
            if (!d.hasVendorId() || !vendor.equals(d.getVendorId()) || !d.hasPath() || !path.equals(d.getPath())) continue;
            return pkg;
        }
        return null;
    }

    @Nullable
    public LocalExtraPkgInfo getExtra(@NonNull String vendor, @NonNull String path) {
        return (LocalExtraPkgInfo)this.getPkgInfo(PkgType.PKG_EXTRAS, vendor, path);
    }

    @Nullable
    public LocalPkgInfo getPkgInfo(@NonNull PkgType filter) {
        assert (filter == PkgType.PKG_TOOLS || filter == PkgType.PKG_PLATFORM_TOOLS || filter == PkgType.PKG_DOCS);
        if (filter != PkgType.PKG_TOOLS && filter != PkgType.PKG_PLATFORM_TOOLS && filter != PkgType.PKG_DOCS) {
            return null;
        }
        Collection existing = this.mLocalPackages.get((Object)filter);
        assert (existing.size() <= 1);
        if (existing.size() > 0) {
            return (LocalPkgInfo)existing.iterator().next();
        }
        File uniqueDir = new File(this.mSdkRoot, filter.getFolderName());
        LocalPkgInfo info = null;
        if (!this.mVisitedDirs.containsEntry((Object)filter, (Object)uniqueDir)) {
            switch (filter) {
                case PKG_TOOLS: {
                    info = this.scanTools(uniqueDir);
                    break;
                }
                case PKG_PLATFORM_TOOLS: {
                    info = this.scanPlatformTools(uniqueDir);
                    break;
                }
                case PKG_DOCS: {
                    info = this.scanDoc(uniqueDir);
                    break;
                }
            }
        }
        this.mVisitedDirs.put((Object)filter, (Object)new LocalDirInfo(this.mFileOp, uniqueDir));
        if (info != null) {
            this.mLocalPackages.put((Object)filter, (Object)info);
        }
        return info;
    }

    @NonNull
    public LocalPkgInfo[] getPkgsInfos(@NonNull PkgType filter) {
        return this.getPkgsInfos(EnumSet.of(filter));
    }

    @NonNull
    public LocalPkgInfo[] getPkgsInfos(@NonNull EnumSet<PkgType> filters) {
        ArrayList list = Lists.newArrayList();
        for (PkgType filter : filters) {
            if (filter == PkgType.PKG_TOOLS || filter == PkgType.PKG_PLATFORM_TOOLS || filter == PkgType.PKG_DOCS) {
                LocalPkgInfo info = this.getPkgInfo(filter);
                if (info == null) continue;
                list.add(info);
                continue;
            }
            Collection existing = this.mLocalPackages.get((Object)filter);
            assert (existing != null);
            if (!existing.isEmpty()) {
                list.addAll(existing);
                continue;
            }
            File subDir = new File(this.mSdkRoot, filter.getFolderName());
            if (this.mVisitedDirs.containsEntry((Object)filter, (Object)subDir)) continue;
            switch (filter) {
                case PKG_BUILD_TOOLS: {
                    this.scanBuildTools(subDir, existing);
                    break;
                }
                case PKG_PLATFORMS: {
                    this.scanPlatforms(subDir, existing);
                    break;
                }
                case PKG_SYS_IMAGES: {
                    this.scanSysImages(subDir, existing);
                    break;
                }
                case PKG_ADDONS: {
                    this.scanAddons(subDir, existing);
                    break;
                }
                case PKG_SAMPLES: {
                    this.scanSamples(subDir, existing);
                    break;
                }
                case PKG_SOURCES: {
                    this.scanSources(subDir, existing);
                    break;
                }
                case PKG_EXTRAS: {
                    this.scanExtras(subDir, existing);
                    break;
                }
            }
            this.mVisitedDirs.put((Object)filter, (Object)new LocalDirInfo(this.mFileOp, subDir));
            list.addAll(existing);
        }
        return list.toArray(new LocalPkgInfo[list.size()]);
    }

    @Nullable
    public BuildToolInfo getBuildTool(@Nullable FullRevision revision) {
        LocalPkgInfo pkg = this.getPkgInfo(PkgType.PKG_BUILD_TOOLS, revision);
        if (pkg instanceof LocalBuildToolPkgInfo) {
            return ((LocalBuildToolPkgInfo)pkg).getBuildToolInfo();
        }
        return null;
    }

    @Nullable
    public BuildToolInfo getLatestBuildTool() {
        if (this.mLegacyBuildTools != null) {
            return this.mLegacyBuildTools;
        }
        Object[] pkgs = this.getPkgsInfos(PkgType.PKG_BUILD_TOOLS);
        if (pkgs.length == 0) {
            LocalPkgInfo ptPkg = this.getPkgInfo(PkgType.PKG_PLATFORM_TOOLS);
            if (ptPkg instanceof LocalPlatformToolPkgInfo && ptPkg.getDesc().getFullRevision().compareTo(new FullRevision(17)) < 0) {
                this.mLegacyBuildTools = this.createLegacyBuildTools((LocalPlatformToolPkgInfo)ptPkg);
                return this.mLegacyBuildTools;
            }
            return null;
        }
        assert (pkgs.length > 0);
        Arrays.sort(pkgs);
        Object pkg = pkgs[pkgs.length - 1];
        if (pkg instanceof LocalBuildToolPkgInfo) {
            return ((LocalBuildToolPkgInfo)pkg).getBuildToolInfo();
        }
        return null;
    }

    @NonNull
    private BuildToolInfo createLegacyBuildTools(@NonNull LocalPlatformToolPkgInfo ptInfo) {
        File platformTools = new File(this.getLocation(), "platform-tools");
        File platformToolsLib = ptInfo.getLocalDir();
        File platformToolsRs = new File(platformTools, "renderscript");
        return new BuildToolInfo(ptInfo.getDesc().getFullRevision(), platformTools, new File(platformTools, SdkConstants.FN_AAPT), new File(platformTools, SdkConstants.FN_AIDL), new File(platformTools, SdkConstants.FN_DX), new File(platformToolsLib, "dx.jar"), new File(platformTools, SdkConstants.FN_RENDERSCRIPT), new File(platformToolsRs, "include"), new File(platformToolsRs, "clang-include"), null, null, null, null);
    }

    @NonNull
    public IAndroidTarget[] getTargets() {
        if (this.mCachedTargets == null) {
            LocalPkgInfo[] pkgsInfos = this.getPkgsInfos(EnumSet.of(PkgType.PKG_PLATFORMS, PkgType.PKG_ADDONS));
            int n = pkgsInfos.length;
            ArrayList<IAndroidTarget> targets = new ArrayList<IAndroidTarget>(n);
            for (LocalPkgInfo info : pkgsInfos) {
                IAndroidTarget target;
                if (!(info instanceof LocalPlatformPkgInfo) || (target = ((LocalPlatformPkgInfo)info).getAndroidTarget()) == null) continue;
                targets.add(target);
            }
            this.mCachedTargets = targets.toArray(new IAndroidTarget[targets.size()]);
        }
        return this.mCachedTargets;
    }

    @Nullable
    public IAndroidTarget getTargetFromHashString(@Nullable String hash) {
        if (hash != null) {
            IAndroidTarget[] targets;
            for (IAndroidTarget target : targets = this.getTargets()) {
                if (target == null || !hash.equals(AndroidTargetHash.getTargetHashString(target))) continue;
                return target;
            }
        }
        return null;
    }

    private LocalToolPkgInfo scanTools(File toolFolder) {
        File[] files;
        Properties props = this.parseProperties(new File(toolFolder, "source.properties"));
        FullRevision rev = PackageParserUtils.getPropertyFull(props, "Pkg.Revision");
        if (rev == null) {
            return null;
        }
        FullRevision minPlatToolsRev = PackageParserUtils.getPropertyFull(props, "Platform.MinPlatformToolsRev");
        if (minPlatToolsRev == null) {
            minPlatToolsRev = FullRevision.NOT_SPECIFIED;
        }
        LocalToolPkgInfo info = new LocalToolPkgInfo(this, toolFolder, props, rev, minPlatToolsRev);
        boolean hasEmulator = false;
        boolean hasAndroid = false;
        String android1 = SdkConstants.androidCmdName().replace(".bat", ".exe");
        String android2 = android1.indexOf(46) == -1 ? null : android1.replace(".exe", ".bat");
        for (File file : files = this.mFileOp.listFiles(toolFolder)) {
            String name = file.getName();
            if (SdkConstants.FN_EMULATOR.equals(name)) {
                hasEmulator = true;
            }
            if (!android1.equals(name) && (android2 == null || !android2.equals(name))) continue;
            hasAndroid = true;
        }
        if (!hasAndroid) {
            info.appendLoadError("Missing %1$s", SdkConstants.androidCmdName());
        }
        if (!hasEmulator) {
            info.appendLoadError("Missing %1$s", SdkConstants.FN_EMULATOR);
        }
        return info;
    }

    private LocalPlatformToolPkgInfo scanPlatformTools(File ptFolder) {
        Properties props = this.parseProperties(new File(ptFolder, "source.properties"));
        FullRevision rev = PackageParserUtils.getPropertyFull(props, "Pkg.Revision");
        if (rev == null) {
            return null;
        }
        LocalPlatformToolPkgInfo info = new LocalPlatformToolPkgInfo(this, ptFolder, props, rev);
        return info;
    }

    private LocalDocPkgInfo scanDoc(File docFolder) {
        Properties props = this.parseProperties(new File(docFolder, "source.properties"));
        MajorRevision rev = PackageParserUtils.getPropertyMajor(props, "Pkg.Revision");
        if (rev == null) {
            return null;
        }
        try {
            AndroidVersion vers = new AndroidVersion(props);
            LocalDocPkgInfo info = new LocalDocPkgInfo(this, docFolder, props, vers, rev);
            if (!this.mFileOp.isFile(new File(docFolder, "index.html"))) {
                info.appendLoadError("Missing index.html", new Object[0]);
            }
            return info;
        }
        catch (AndroidVersion.AndroidVersionException e) {
            return null;
        }
    }

    private void scanBuildTools(File collectionDir, Collection<LocalPkgInfo> outCollection) {
        for (File buildToolDir : this.mFileOp.listFiles(collectionDir)) {
            if (!this.mFileOp.isDirectory(buildToolDir) || this.mVisitedDirs.containsEntry((Object)PkgType.PKG_BUILD_TOOLS, (Object)buildToolDir)) continue;
            this.mVisitedDirs.put((Object)PkgType.PKG_BUILD_TOOLS, (Object)new LocalDirInfo(this.mFileOp, buildToolDir));
            Properties props = this.parseProperties(new File(buildToolDir, "source.properties"));
            FullRevision rev = PackageParserUtils.getPropertyFull(props, "Pkg.Revision");
            if (rev == null) continue;
            BuildToolInfo btInfo = new BuildToolInfo(rev, buildToolDir);
            LocalBuildToolPkgInfo pkgInfo = new LocalBuildToolPkgInfo(this, buildToolDir, props, rev, btInfo);
            outCollection.add(pkgInfo);
        }
    }

    private void scanPlatforms(File collectionDir, Collection<LocalPkgInfo> outCollection) {
        for (File platformDir : this.mFileOp.listFiles(collectionDir)) {
            if (!this.mFileOp.isDirectory(platformDir) || this.mVisitedDirs.containsEntry((Object)PkgType.PKG_PLATFORMS, (Object)platformDir)) continue;
            this.mVisitedDirs.put((Object)PkgType.PKG_PLATFORMS, (Object)new LocalDirInfo(this.mFileOp, platformDir));
            Properties props = this.parseProperties(new File(platformDir, "source.properties"));
            MajorRevision rev = PackageParserUtils.getPropertyMajor(props, "Pkg.Revision");
            if (rev == null) continue;
            FullRevision minToolsRev = PackageParserUtils.getPropertyFull(props, "Platform.MinToolsRev");
            if (minToolsRev == null) {
                minToolsRev = FullRevision.NOT_SPECIFIED;
            }
            try {
                AndroidVersion vers = new AndroidVersion(props);
                LocalPlatformPkgInfo pkgInfo = new LocalPlatformPkgInfo(this, platformDir, props, vers, rev, minToolsRev);
                outCollection.add(pkgInfo);
            }
            catch (AndroidVersion.AndroidVersionException e) {
                // empty catch block
            }
        }
    }

    private void scanAddons(File collectionDir, Collection<LocalPkgInfo> outCollection) {
        for (File addonDir : this.mFileOp.listFiles(collectionDir)) {
            if (!this.mFileOp.isDirectory(addonDir) || this.mVisitedDirs.containsEntry((Object)PkgType.PKG_ADDONS, (Object)addonDir)) continue;
            this.mVisitedDirs.put((Object)PkgType.PKG_ADDONS, (Object)new LocalDirInfo(this.mFileOp, addonDir));
            Properties props = this.parseProperties(new File(addonDir, "source.properties"));
            MajorRevision rev = PackageParserUtils.getPropertyMajor(props, "Pkg.Revision");
            if (rev == null) continue;
            try {
                AndroidVersion vers = new AndroidVersion(props);
                LocalAddonPkgInfo pkgInfo = new LocalAddonPkgInfo(this, addonDir, props, vers, rev);
                outCollection.add(pkgInfo);
            }
            catch (AndroidVersion.AndroidVersionException e) {
                // empty catch block
            }
        }
    }

    private void scanSysImages(File collectionDir, Collection<LocalPkgInfo> outCollection) {
        for (File platformDir : this.mFileOp.listFiles(collectionDir)) {
            if (!this.mFileOp.isDirectory(platformDir) || this.mVisitedDirs.containsEntry((Object)PkgType.PKG_SYS_IMAGES, (Object)platformDir)) continue;
            this.mVisitedDirs.put((Object)PkgType.PKG_SYS_IMAGES, (Object)new LocalDirInfo(this.mFileOp, platformDir));
            for (File abiDir : this.mFileOp.listFiles(platformDir)) {
                if (!this.mFileOp.isDirectory(abiDir) || this.mVisitedDirs.containsEntry((Object)PkgType.PKG_SYS_IMAGES, (Object)abiDir)) continue;
                this.mVisitedDirs.put((Object)PkgType.PKG_SYS_IMAGES, (Object)new LocalDirInfo(this.mFileOp, abiDir));
                Properties props = this.parseProperties(new File(abiDir, "source.properties"));
                MajorRevision rev = PackageParserUtils.getPropertyMajor(props, "Pkg.Revision");
                if (rev == null) continue;
                try {
                    AndroidVersion vers = new AndroidVersion(props);
                    LocalSysImgPkgInfo pkgInfo = new LocalSysImgPkgInfo(this, abiDir, props, vers, abiDir.getName(), rev);
                    outCollection.add(pkgInfo);
                }
                catch (AndroidVersion.AndroidVersionException e) {
                    // empty catch block
                }
            }
        }
    }

    private void scanSamples(File collectionDir, Collection<LocalPkgInfo> outCollection) {
        for (File platformDir : this.mFileOp.listFiles(collectionDir)) {
            if (!this.mFileOp.isDirectory(platformDir) || this.mVisitedDirs.containsEntry((Object)PkgType.PKG_SAMPLES, (Object)platformDir)) continue;
            this.mVisitedDirs.put((Object)PkgType.PKG_SAMPLES, (Object)new LocalDirInfo(this.mFileOp, platformDir));
            Properties props = this.parseProperties(new File(platformDir, "source.properties"));
            MajorRevision rev = PackageParserUtils.getPropertyMajor(props, "Pkg.Revision");
            if (rev == null) continue;
            FullRevision minToolsRev = PackageParserUtils.getPropertyFull(props, "Platform.MinToolsRev");
            if (minToolsRev == null) {
                minToolsRev = FullRevision.NOT_SPECIFIED;
            }
            try {
                AndroidVersion vers = new AndroidVersion(props);
                LocalSamplePkgInfo pkgInfo = new LocalSamplePkgInfo(this, platformDir, props, vers, rev, minToolsRev);
                outCollection.add(pkgInfo);
            }
            catch (AndroidVersion.AndroidVersionException e) {
                // empty catch block
            }
        }
    }

    private void scanSources(File collectionDir, Collection<LocalPkgInfo> outCollection) {
        for (File platformDir : this.mFileOp.listFiles(collectionDir)) {
            if (!this.mFileOp.isDirectory(platformDir) || this.mVisitedDirs.containsEntry((Object)PkgType.PKG_SOURCES, (Object)platformDir)) continue;
            this.mVisitedDirs.put((Object)PkgType.PKG_SOURCES, (Object)new LocalDirInfo(this.mFileOp, platformDir));
            Properties props = this.parseProperties(new File(platformDir, "source.properties"));
            MajorRevision rev = PackageParserUtils.getPropertyMajor(props, "Pkg.Revision");
            if (rev == null) continue;
            try {
                AndroidVersion vers = new AndroidVersion(props);
                LocalSourcePkgInfo pkgInfo = new LocalSourcePkgInfo(this, platformDir, props, vers, rev);
                outCollection.add(pkgInfo);
            }
            catch (AndroidVersion.AndroidVersionException e) {
                // empty catch block
            }
        }
    }

    private void scanExtras(File collectionDir, Collection<LocalPkgInfo> outCollection) {
        for (File vendorDir : this.mFileOp.listFiles(collectionDir)) {
            if (!this.mFileOp.isDirectory(vendorDir) || this.mVisitedDirs.containsEntry((Object)PkgType.PKG_EXTRAS, (Object)vendorDir)) continue;
            this.mVisitedDirs.put((Object)PkgType.PKG_EXTRAS, (Object)new LocalDirInfo(this.mFileOp, vendorDir));
            for (File extraDir : this.mFileOp.listFiles(vendorDir)) {
                if (!this.mFileOp.isDirectory(extraDir) || this.mVisitedDirs.containsEntry((Object)PkgType.PKG_EXTRAS, (Object)extraDir)) continue;
                this.mVisitedDirs.put((Object)PkgType.PKG_EXTRAS, (Object)new LocalDirInfo(this.mFileOp, extraDir));
                Properties props = this.parseProperties(new File(extraDir, "source.properties"));
                NoPreviewRevision rev = PackageParserUtils.getPropertyNoPreview(props, "Pkg.Revision");
                if (rev == null) continue;
                String oldPaths = PackageParserUtils.getProperty(props, "Extra.OldPaths", null);
                LocalExtraPkgInfo pkgInfo = new LocalExtraPkgInfo(this, extraDir, props, vendorDir.getName(), extraDir.getName(), PkgDescExtra.convertOldPaths(oldPaths), rev);
                outCollection.add(pkgInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties parseProperties(File propsFile) {
        InputStream fis = null;
        try {
            if (this.mFileOp.exists(propsFile)) {
                fis = this.mFileOp.newFileInputStream(propsFile);
                Properties props = new Properties();
                props.load(fis);
                if (props.size() > 0) {
                    Properties properties = props;
                    return properties;
                }
            }
        }
        catch (IOException e) {
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }
}

