/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.local;

import com.android.SdkConstants;
import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.SystemImage;
import com.android.sdklib.internal.androidTarget.AddOnTarget;
import com.android.sdklib.internal.androidTarget.PlatformTarget;
import com.android.sdklib.internal.project.ProjectProperties;
import com.android.sdklib.internal.repository.packages.AddonPackage;
import com.android.sdklib.internal.repository.packages.Package;
import com.android.sdklib.io.IFileOp;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.MajorRevision;
import com.android.sdklib.repository.descriptors.IAddonDesc;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.sdklib.repository.local.LocalPkgInfo;
import com.android.sdklib.repository.local.LocalPlatformPkgInfo;
import com.android.sdklib.repository.local.LocalSdk;
import com.android.utils.Pair;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LocalAddonPkgInfo
extends LocalPlatformPkgInfo {
    public static final String ADDON_NAME = "name";
    public static final String ADDON_VENDOR = "vendor";
    public static final String ADDON_API = "api";
    public static final String ADDON_DESCRIPTION = "description";
    public static final String ADDON_LIBRARIES = "libraries";
    public static final String ADDON_DEFAULT_SKIN = "skin";
    public static final String ADDON_USB_VENDOR = "usb-vendor";
    public static final String ADDON_REVISION = "revision";
    public static final String ADDON_REVISION_OLD = "version";
    private static final Pattern PATTERN_LIB_DATA = Pattern.compile("^([a-zA-Z0-9._-]+\\.jar);(.*)$", 2);
    private static final Pattern PATTERN_USB_IDS = Pattern.compile("^0x[a-f0-9]{4}$", 2);
    @NonNull
    private final IPkgDesc mAddonDesc;
    private String mTargetHash;
    private String mVendorId;

    public LocalAddonPkgInfo(@NonNull LocalSdk localSdk, @NonNull File localDir, @NonNull Properties sourceProps, @NonNull AndroidVersion version, @NonNull MajorRevision revision) {
        super(localSdk, localDir, sourceProps, version, revision, FullRevision.NOT_SPECIFIED);
        this.mAddonDesc = PkgDesc.newAddon(version, revision, new IAddonDesc(){

            @Override
            @NonNull
            public String getTargetHash() {
                return LocalAddonPkgInfo.this.getTargetHash();
            }

            @Override
            @NonNull
            public String getVendorId() {
                return LocalAddonPkgInfo.this.getVendorId();
            }
        });
    }

    @Override
    @NonNull
    public IPkgDesc getDesc() {
        return this.mAddonDesc;
    }

    @NonNull
    public String getVendorId() {
        if (this.mVendorId == null) {
            IAndroidTarget target = this.getAndroidTarget();
            String vendor = null;
            if (target != null) {
                vendor = target.getVendor();
            } else {
                Pair<Map<String, String>, String> infos = this.parseAddonProperties();
                Map map = (Map)infos.getFirst();
                if (map != null) {
                    vendor = (String)map.get(ADDON_VENDOR);
                }
            }
            if (vendor == null) {
                return "invalid";
            }
            this.mVendorId = vendor;
        }
        return this.mVendorId;
    }

    @Override
    @NonNull
    public String getTargetHash() {
        if (this.mTargetHash == null) {
            IAndroidTarget target = this.getAndroidTarget();
            String vendor = null;
            String name = null;
            if (target != null) {
                vendor = target.getVendor();
                name = target.getName();
            } else {
                Pair<Map<String, String>, String> infos = this.parseAddonProperties();
                Map map = (Map)infos.getFirst();
                if (map != null) {
                    vendor = (String)map.get(ADDON_VENDOR);
                    name = (String)map.get(ADDON_NAME);
                }
            }
            if (vendor == null) {
                vendor = this.mVendorId;
            }
            if (vendor == null || name == null) {
                return "invalid";
            }
            this.mVendorId = vendor;
            this.mTargetHash = AndroidTargetHash.getAddonHashString(vendor, name, this.getDesc().getAndroidVersion());
        }
        return this.mTargetHash;
    }

    @Override
    @Nullable
    protected Package createPackage() {
        IAndroidTarget target = this.getAndroidTarget();
        if (target != null) {
            return AddonPackage.create(target, this.getSourceProperties());
        }
        return null;
    }

    @Override
    @Nullable
    protected IAndroidTarget createAndroidTarget() {
        LocalSdk sdk = this.getLocalSdk();
        IFileOp fileOp = sdk.getFileOp();
        Pair<Map<String, String>, String> infos = this.parseAddonProperties();
        Map propertyMap = (Map)infos.getFirst();
        String error = (String)infos.getSecond();
        if (error != null) {
            this.appendLoadError("Ignoring add-on '%1$s': %2$s", this.getLocalDir().getName(), error);
            return null;
        }
        try {
            int usbVendorId;
            String[] libraries;
            assert (propertyMap != null);
            String api = (String)propertyMap.get(ADDON_API);
            String name = (String)propertyMap.get(ADDON_NAME);
            String vendor = (String)propertyMap.get(ADDON_VENDOR);
            assert (api != null);
            assert (name != null);
            assert (vendor != null);
            PlatformTarget baseTarget = null;
            LocalPkgInfo plat = sdk.getPkgInfo(PkgType.PKG_PLATFORMS, this.getDesc().getAndroidVersion());
            if (plat instanceof LocalPlatformPkgInfo) {
                baseTarget = (PlatformTarget)((LocalPlatformPkgInfo)plat).getAndroidTarget();
            }
            assert (baseTarget != null);
            String description = (String)propertyMap.get(ADDON_DESCRIPTION);
            int revisionValue = 1;
            String revision = (String)propertyMap.get(ADDON_REVISION);
            if (revision == null) {
                revision = (String)propertyMap.get(ADDON_REVISION_OLD);
            }
            if (revision != null) {
                revisionValue = Integer.parseInt(revision);
            }
            String librariesValue = (String)propertyMap.get(ADDON_LIBRARIES);
            HashMap<String, String[]> libMap = null;
            if (librariesValue != null && !(librariesValue = librariesValue.trim()).isEmpty() && (libraries = librariesValue.split(";")).length > 0) {
                libMap = new HashMap<String, String[]>();
                for (String libName : libraries) {
                    String libData = (String)propertyMap.get(libName = libName.trim());
                    if (libData != null) {
                        Matcher m = PATTERN_LIB_DATA.matcher(libData);
                        if (m.matches()) {
                            libMap.put(libName, new String[]{m.group(1), m.group(2)});
                            continue;
                        }
                        this.appendLoadError("Ignoring library '%1$s', property value has wrong format\n\t%2$s", libName, libData);
                        continue;
                    }
                    this.appendLoadError("Ignoring library '%1$s', missing property value", libName, libData);
                }
            }
            ISystemImage[] systemImages = this.getAddonSystemImages();
            boolean hasRenderingLibrary = false;
            boolean hasRenderingResources = false;
            File dataFolder = new File(this.getLocalDir(), "data");
            if (fileOp.isDirectory(dataFolder)) {
                hasRenderingLibrary = fileOp.isFile(new File(dataFolder, "layoutlib.jar"));
                hasRenderingResources = fileOp.isDirectory(new File(dataFolder, "res")) && fileOp.isDirectory(new File(dataFolder, "fonts"));
            }
            AddOnTarget target = new AddOnTarget(this.getLocalDir().getAbsolutePath(), name, vendor, revisionValue, description, systemImages, libMap, hasRenderingLibrary, hasRenderingResources, baseTarget);
            String[] skins = this.parseSkinFolder(target.getPath(5));
            String defaultSkin = (String)propertyMap.get(ADDON_DEFAULT_SKIN);
            if (defaultSkin == null) {
                defaultSkin = skins.length == 1 ? skins[0] : baseTarget.getDefaultSkin();
            }
            if ((usbVendorId = this.convertId((String)propertyMap.get(ADDON_USB_VENDOR))) != 0) {
                target.setUsbVendorId(usbVendorId);
            }
            target.setSkins(skins, defaultSkin);
            return target;
        }
        catch (Exception e) {
            this.appendLoadError("Ignoring add-on '%1$s': error %2$s.", this.getLocalDir().getName(), e.toString());
            return null;
        }
    }

    @NonNull
    private Pair<Map<String, String>, String> parseAddonProperties() {
        String error;
        Map<String, String> propertyMap;
        block8: {
            block13: {
                String api;
                block12: {
                    block11: {
                        block10: {
                            block7: {
                                File addOnManifest;
                                IFileOp fileOp;
                                block9: {
                                    propertyMap = null;
                                    error = null;
                                    fileOp = this.getLocalSdk().getFileOp();
                                    if (fileOp.isFile(addOnManifest = new File(this.getLocalDir(), "manifest.ini"))) break block9;
                                    error = String.format("File not found: %1$s", "manifest.ini");
                                    break block8;
                                }
                                try {
                                    propertyMap = ProjectProperties.parsePropertyStream(fileOp.newFileInputStream(addOnManifest), addOnManifest.getPath(), null);
                                    if (propertyMap != null) break block7;
                                    error = String.format("Failed to parse properties from %1$s", "manifest.ini");
                                    break block8;
                                }
                                catch (FileNotFoundException ignore) {
                                    // empty catch block
                                }
                            }
                            assert (propertyMap != null);
                            String name = (String)propertyMap.get(ADDON_NAME);
                            if (name != null) break block10;
                            error = LocalAddonPkgInfo.addonManifestWarning(ADDON_NAME);
                            break block8;
                        }
                        String vendor = propertyMap.get(ADDON_VENDOR);
                        if (vendor != null) break block11;
                        error = LocalAddonPkgInfo.addonManifestWarning(ADDON_VENDOR);
                        break block8;
                    }
                    api = propertyMap.get(ADDON_API);
                    if (api != null) break block12;
                    error = LocalAddonPkgInfo.addonManifestWarning(ADDON_API);
                    break block8;
                }
                IAndroidTarget baseTarget = null;
                LocalPkgInfo plat = this.getLocalSdk().getPkgInfo(PkgType.PKG_PLATFORMS, this.getDesc().getAndroidVersion());
                if (plat instanceof LocalPlatformPkgInfo) {
                    baseTarget = ((LocalPlatformPkgInfo)plat).getAndroidTarget();
                }
                if (baseTarget != null) break block13;
                error = String.format("Unable to find base platform with API level '%1$s'", api);
                break block8;
            }
            String revision = propertyMap.get(ADDON_REVISION);
            if (revision == null) {
                revision = propertyMap.get(ADDON_REVISION_OLD);
            }
            if (revision == null) break block8;
            try {
                Integer.parseInt(revision);
            }
            catch (NumberFormatException e) {
                error = String.format("%1$s is not a valid number in %2$s.", ADDON_REVISION, "build.prop");
            }
        }
        return Pair.of(propertyMap, (Object)error);
    }

    @NonNull
    private static String addonManifestWarning(@NonNull String valueName) {
        return String.format("'%1$s' is missing from %2$s.", valueName, "manifest.ini");
    }

    private int convertId(@Nullable String value) {
        if (value != null && !value.isEmpty() && PATTERN_USB_IDS.matcher(value).matches()) {
            String v = value.substring(2);
            try {
                return Integer.parseInt(v, 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    @NonNull
    private ISystemImage[] getAddonSystemImages() {
        File[] files;
        TreeSet<SystemImage> found = new TreeSet<SystemImage>();
        IFileOp fileOp = this.getLocalSdk().getFileOp();
        File imagesDir = new File(this.getLocalDir(), SdkConstants.OS_IMAGES_FOLDER);
        boolean hasImgFiles = false;
        for (File file : files = fileOp.listFiles(imagesDir)) {
            if (fileOp.isDirectory(file)) {
                found.add(new SystemImage(file, ISystemImage.LocationType.IN_PLATFORM_SUBFOLDER, file.getName()));
                continue;
            }
            if (hasImgFiles || !fileOp.isFile(file) || !file.getName().endsWith(".img")) continue;
            hasImgFiles = true;
        }
        if (found.isEmpty() && hasImgFiles && fileOp.isDirectory(imagesDir)) {
            found.add(new SystemImage(imagesDir, ISystemImage.LocationType.IN_PLATFORM_LEGACY, "armeabi"));
        }
        return found.toArray(new ISystemImage[found.size()]);
    }
}

